package csbase.server.services.opendreamsservice.algorithm.v1_0;

import java.util.HashMap;
import java.util.Map;

import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.ClientSGAFileParameter;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.OutputFileListParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parameters.TextParameter;

/**
 * Mapeia os tipos de parmetros com o identificador da IDL correspondente.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ParameterMapping {

  /**
   * Possui o mapeamento dos tipos de parmetros para os identificadores IDL
   * correspondentes
   */
  private Map<String, String> map;

  /**
   * Instncia nica dessa classe.
   */
  private static ParameterMapping instance;

  /**
   * Construtor
   */
  private ParameterMapping() {
    map = new HashMap<String, String>();

    map.put(BooleanParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.BooleanParameterHelper
      .id());
    map
    .put(
      ClientSGAFileParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.ClientSGAFileParameterHelper
      .id());

    map
    .put(
      DoubleListParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.DoubleListParameterHelper
      .id());

    map.put(DoubleParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.DoubleParameterHelper
      .id());

    map
    .put(
      EnumerationListParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.EnumerationListParameterHelper
      .id());

    map
    .put(
      EnumerationParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.EnumerationParameterHelper
      .id());

    map.put(FormulaParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.FormulaParameterHelper
      .id());

    map
    .put(
      InputFileListParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.InputFileListParameterHelper
      .id());

    map.put(InputFileParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.InputFileParameterHelper
      .id());

    map
    .put(
      IntegerListParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.IntegerListParameterHelper
      .id());

    map.put(IntegerParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.IntegerParameterHelper
      .id());

    map
    .put(
      OutputFileListParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.OutputFileListParameterHelper
      .id());

    map
    .put(
      OutputFileParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.OutputFileParameterHelper
      .id());

    map.put(TableParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.TableParameterHelper
      .id());

    map.put(TextListParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.TextListParameterHelper
      .id());

    map
    .put(TextParameter.TYPE,
      tecgraf.openbus.algorithmservice.v1_0.parameters.TextParameterHelper
      .id());
  }

  /**
   * Obtm a instncia dessa classe. Se no existir,  criada.
   *
   * @return a nica instncia dessa classe.
   */
  public static ParameterMapping getInstance() {
    if (instance == null) {
      instance = new ParameterMapping();
    }
    return instance;
  }

  /**
   * Obtm o identificador IDL correspondente ao tipo de parmetro. A IDL deve
   * ser compatvel com a verso do AlgorithmService ao qual esse mapeamento
   * atende. Se no existir um mapeamento definido, retorna null;
   *
   * @param parameterType a representao textual do tipo do parmetro.
   * @return o identificador IDL correspondente ao tipo de parmetro ou null
   *         caso no tenha sido mapeado.
   */
  public String getIDLType(String parameterType) {
    return map.get(parameterType);
  }
}
