package csbase.server.services.restservice;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;

import csbase.exception.CSBaseRuntimeException;
import csbase.remote.RestServiceInterface;
import ibase.common.RestErrorMessage;

/**
 * Classe responsvel pelo mapeamento das excees runtime que o servidor CSBase
 * pode lanar para indicar falha no processamento das requisies aos servios.
 * A exceo j possui uma mensagem no idioma que foi configurado como parmetro
 * na requisio http ou, no caso desse parmetro no estar definidor, no idioma
 * default do servidor.
 * 
 * O retorno  enviado como uma resposta de BAD_REQUEST e com um objeto JSON que
 * possui a mensagem da exceo correspondente.
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class CSBaseRuntimeExceptionMapper implements
  ExceptionMapper<CSBaseRuntimeException> {

  /** Servico rest */
  @Context
  RestServiceInterface restService;

  /**
   * {@inheritDoc}
   */
  @Override
  public Response toResponse(CSBaseRuntimeException exception) {
    restService.logInfoMessage(exception.getMessage());
    return Response.status(Status.BAD_REQUEST).entity(new RestErrorMessage(
      exception.getMessage())).type(MediaType.APPLICATION_JSON).build();
  }
}
