/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.csfsservice;

import csbase.exception.OperationFailureException;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csfs.remote.FileAlreadyExistsException;
import csfs.remote.FileNotFoundException;
import csfs.remote.FileServer;
import csfs.remote.FileServerHelper;
import csfs.remote.InvalidPathException;
import csfs.remote.InvalidStateException;
import csfs.remote.NotDirectoryException;
import csfs.remote.NotFileException;
import csfs.remote.RemoteFile;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import tecgraf.javautils.core.io.FileUtils;

public class CSFSService
extends Service {
    private static final String[] CFSF_PROJECT_MOUNT_POINT = new String[]{"project_csfs"};
    private static final String[] CFSF_ALGORITHM_MOUNT_POINT = new String[]{"algorithms_csfs"};
    private ORB orb;
    private String corbalocPattern;
    private int csfsPort;
    private String csfsHost;
    private FileServer mainFileServer;
    public static final String SERVICE_NAME = "CSFSService";
    private String transferMethod;

    private void checkActive() throws ServerException {
        if (!this.isActive()) {
            throw new ServerException("Servi\u00e7o CSFS n\u00e3o dispon\u00edvel");
        }
    }

    public static CSFSService getInstance() {
        return (CSFSService)CSFSService.getInstance(SERVICE_NAME);
    }

    protected boolean has2Update(java.lang.Object arg, java.lang.Object event) {
        return false;
    }

    public static void createService() throws ServerException {
        new CSFSService();
    }

    protected CSFSService() throws ServerException {
        super(SERVICE_NAME);
        this.setEnabled(this.getBooleanProperty("ENABLED"));
    }

    @Override
    public void initService() throws ServerException {
        this.corbalocPattern = this.getStringProperty("CSFS_CORBALOC_PATTERN");
        this.csfsPort = this.getIntProperty("CSFS_PORT");
        this.csfsHost = this.getStringProperty("CSFS_HOST");
        final int retrySleepTime = this.getIntProperty("RETRY_SLEEP_TIME");
        this.transferMethod = this.getStringProperty("TRANSFER_METHOD");
        Properties props = new Properties();
        props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        props.setProperty("jacorb.connection.client.disconnect_after_systemexception", "false");
        try {
            this.orb = ORB.init((String[])null, (Properties)props);
        }
        catch (Exception exc) {
            Server.logSevereMessage("Falha na inicializa\u00e7\u00e3o do orb.", exc);
            throw new ServerException("ORB.init() failed!");
        }
        Thread csfsRemoteLocatorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!CSFSService.this.isConnected()) {
                    try {
                        CSFSService.this.mainFileServer = CSFSService.this.getFileServer(CSFSService.this.csfsHost, CSFSService.this.csfsPort);
                        Server.logInfoMessage("Recuperei o mainFileServer " + CSFSService.this.csfsHost);
                        CSFSService.this.removeMountPoints();
                        String projectDirProperty = CSFSService.this.getStringProperty("PROJECT_DIR_FROM_ROOT");
                        String algorithmsDirProperty = CSFSService.this.getStringProperty("ALGORITHM_DIR_FROM_ROOT");
                        String[] projectDir = FileUtils.splitPath((String)projectDirProperty);
                        String[] algorithmsDir = FileUtils.splitPath((String)algorithmsDirProperty);
                        this.addMountPoint(CFSF_PROJECT_MOUNT_POINT, projectDir);
                        this.addMountPoint(CFSF_ALGORITHM_MOUNT_POINT, algorithmsDir);
                    }
                    catch (ServerException exc) {
                        Server.logFineMessage("N\u00e3o consegui recuperar o mainFileServer (exc=" + exc.getMessage() + "). Vou tentar novamente em " + retrySleepTime + " ms...");
                    }
                    catch (OperationFailureException e) {
                        Server.logSevereMessage("N\u00e3o foi poss\u00edvel montar os diret\u00f3rios exportados pelo CSFS:", e);
                    }
                    catch (Exception e) {
                        Server.logSevereMessage("Exce\u00e7\u00e3o ao iniciar o servi\u00e7o CSFS:", e);
                    }
                    try {
                        Thread.sleep(retrySleepTime);
                    }
                    catch (InterruptedException e) {
                        Server.logSevereMessage("InterruptedException", e);
                    }
                }
            }

            private RemoteFile addMountPoint(String[] mountPoint, String[] target) throws OperationFailureException {
                try {
                    RemoteFile root = CSFSService.this.mainFileServer.getRoot();
                    RemoteFile targetDir = root.getChild(target);
                    root.addMountPoint(mountPoint, targetDir);
                    return targetDir;
                }
                catch (Exception e) {
                    Server.logSevereMessage("N\u00e3o foi poss\u00edvel montar o diret\u00f3rio " + FileUtils.joinPath((String[])target) + " em " + FileUtils.joinPath((String[])mountPoint), e);
                    throw new OperationFailureException((Throwable)e);
                }
            }
        });
        csfsRemoteLocatorThread.setName(((java.lang.Object)((java.lang.Object)this)).getClass().getSimpleName() + "::CSFSRemoteLocatorThread");
        csfsRemoteLocatorThread.start();
    }

    @Override
    public void shutdownService() throws ServerException {
        if (this.isConnected()) {
            this.removeMountPoints();
        }
        this.orb.shutdown(false);
    }

    public int getPort() {
        return this.csfsPort;
    }

    public String getHost() {
        return this.csfsHost;
    }

    public String getCorbalocPattern() {
        return this.corbalocPattern;
    }

    private void removeMountPoints() throws ServerException {
        if (this.checkExistence(this.csfsHost, this.csfsPort, CFSF_PROJECT_MOUNT_POINT)) {
            this.removeMountPoint(CFSF_PROJECT_MOUNT_POINT);
        }
        if (this.checkExistence(this.csfsHost, this.csfsPort, CFSF_ALGORITHM_MOUNT_POINT)) {
            this.removeMountPoint(CFSF_ALGORITHM_MOUNT_POINT);
        }
    }

    private void removeMountPoint(String[] mountPoint) {
        try {
            RemoteFile root = this.mainFileServer.getRoot();
            root.removeMountPoint(mountPoint);
        }
        catch (Exception e) {
            Server.logWarningMessage("N\u00e3o foi remover o mount point em " + FileUtils.joinPath((String[])mountPoint));
        }
    }

    private boolean isConnected() {
        return this.mainFileServer != null;
    }

    public boolean checkExistence(String host, int port, String[] path) throws ServerException {
        this.checkActive();
        boolean response = false;
        FileServer fs = this.getFileServer(host, port);
        try {
            fs.getRoot().getChild(path);
            response = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (csfs.remote.ServerException exc) {
            Server.logSevereMessage("Error in CSFS subsystem!", exc);
            throw new ServerException("Remote File Server Exception. message=" + exc.message, exc);
        }
        catch (Exception exc) {
            throw new ServerException("Exception during checkExistence operation. exc.getClass().getName()=" + exc.getClass().getName() + " file=" + FileUtils.joinPath((String[])this.getName(exc)), exc);
        }
        return response;
    }

    public String getRootPath(String host, int port) throws ServerException {
        this.checkActive();
        FileServer fs = this.getFileServer(host, port);
        try {
            return fs.getProperty("ROOT_DIR");
        }
        catch (csfs.remote.ServerException exc) {
            throw new ServerException("Exception during getRootPath operation. exc.getClass().getName()=" + ((java.lang.Object)((java.lang.Object)exc)).getClass().getName() + " file=" + FileUtils.joinPath((String[])this.getName((Exception)((java.lang.Object)exc))), exc);
        }
    }

    public String[] getCSFSProjectsRootPath() throws ServerException {
        this.checkActive();
        return CFSF_PROJECT_MOUNT_POINT;
    }

    public String[] getCSFSAlgorithmsRootPath() throws ServerException {
        this.checkActive();
        return CFSF_ALGORITHM_MOUNT_POINT;
    }

    private FileServer getFileServer(String host, int port) throws ServerException {
        FileServer response;
        String corbaloc = MessageFormat.format(this.corbalocPattern, host, "" + port);
        try {
            response = FileServerHelper.narrow((Object)this.orb.string_to_object(corbaloc));
            response.getName();
        }
        catch (Exception exc) {
            throw new ServerException("Error contacting remote file server! corbaloc=" + corbaloc + "\n", exc);
        }
        return response;
    }

    public Map<String[], Long> getTimestamps(String host, int port, String[] path) throws ServerException {
        this.checkActive();
        HashMap<String[], Long> response = new HashMap<String[], Long>();
        try {
            FileServer targetFS = this.getFileServer(host, port);
            RemoteFile file = this.lookup(targetFS, path);
            this.visitRemoteFilesGettingTimestamps(response, file);
        }
        catch (FileNotFoundException exc) {
            throw new ServerException("Unable to get timestamps for an unexistent path. path=" + path + " address=" + host + ":" + port, exc);
        }
        return response;
    }

    public Map<String[], Long> getTimestamps(String[] path) throws ServerException {
        return this.getTimestamps(this.csfsHost, this.csfsPort, path);
    }

    private void visitRemoteFilesGettingTimestamps(Map<String[], Long> info, RemoteFile root) throws ServerException {
        try {
            if (!root.isDirectory()) {
                info.put(root.getFullName(), new Long(root.lastModified()));
            } else {
                RemoteFile[] children;
                for (RemoteFile element : children = root.getChildren()) {
                    this.visitRemoteFilesGettingTimestamps(info, element);
                }
            }
        }
        catch (csfs.remote.ServerException exc) {
            Server.logSevereMessage("Error in CSFS subsystem!", exc);
            throw new ServerException("An error occurred in remote file server. message=" + exc.message, exc);
        }
        catch (Exception exc) {
            throw new ServerException("Exception during visitRemoteFilesGettingTimestamps operation.exc.getClass().getName()=" + exc.getClass().getName() + " file=" + FileUtils.joinPath((String[])this.getName(exc)), exc);
        }
    }

    public void copyTo(String host, int port, String[] sourcePath, String[] targetPath) throws ServerException {
        this.checkActive();
        FileServer sgaFileServer = this.getFileServer(host, port);
        this.copy(this.mainFileServer, sourcePath, sgaFileServer, targetPath);
    }

    public void copyFrom(String host, int port, String[] sourcePath, String[] targetPath) throws ServerException {
        this.checkActive();
        FileServer sgaFileServer = this.getFileServer(host, port);
        this.copy(sgaFileServer, sourcePath, this.mainFileServer, targetPath);
    }

    private void copy(FileServer sourceFS, String[] sourcePath, FileServer targetFS, String[] targetPath) throws ServerException {
        try {
            RemoteFile sourceFile = this.lookup(sourceFS, sourcePath);
            RemoteFile targetFile = this.lookupOrCreate(targetFS, targetPath, sourceFile.isDirectory());
            if (sourceFile.isDirectory()) {
                this.copyDirectory(sourceFile, targetFile);
            } else {
                this.copyFile(sourceFile, targetFile);
            }
        }
        catch (csfs.remote.ServerException exc) {
            Server.logSevereMessage("Error in CSFS subsystem!", exc);
            throw new ServerException("Remote File Server Exception. message=" + exc.message, exc);
        }
        catch (Exception exc) {
            throw new ServerException("Exception during copy operation. exc.getClass().getName()=" + exc.getClass().getName() + " file=" + FileUtils.joinPath((String[])this.getName(exc)) + " source:" + FileUtils.joinPath((String[])sourcePath) + " target:" + FileUtils.joinPath((String[])targetPath), exc);
        }
    }

    private void copyDirectory(RemoteFile sourceFile, RemoteFile targetFile) throws NotDirectoryException, csfs.remote.ServerException, InvalidStateException, InvalidPathException, FileNotFoundException, ServerException, FileAlreadyExistsException, NotFileException {
        RemoteFile[] children;
        for (RemoteFile element : children = sourceFile.getChildren()) {
            if (element.isDirectory()) {
                RemoteFile targetChildFile;
                block4: {
                    try {
                        targetChildFile = targetFile.createDirectory(new String[]{element.getName()});
                    }
                    catch (FileAlreadyExistsException e) {
                        targetChildFile = targetFile.getChild(new String[]{element.getName()});
                        if (targetChildFile.isDirectory()) break block4;
                        throw new ServerException("There is a file in the way: " + FileUtils.joinPath((String[])e.name), e);
                    }
                }
                this.copyDirectory(element, targetChildFile);
                continue;
            }
            this.copyFile(element, targetFile);
        }
    }

    private void copyFile(RemoteFile sourceFile, RemoteFile targetFile) throws csfs.remote.ServerException, InvalidStateException, NotDirectoryException, InvalidPathException, FileAlreadyExistsException, NotFileException, FileNotFoundException, ServerException {
        RemoteFile targetCopyFile;
        block3: {
            targetCopyFile = targetFile;
            if (targetFile.isDirectory()) {
                try {
                    targetCopyFile = targetFile.createFile(new String[]{sourceFile.getName()});
                }
                catch (FileAlreadyExistsException e) {
                    targetCopyFile = targetFile.getChild(new String[]{sourceFile.getName()});
                    if (!targetCopyFile.isDirectory()) break block3;
                    throw new ServerException("There is a file in the way: " + FileUtils.joinPath((String[])e.name), e);
                }
            }
        }
        sourceFile.copyTo(targetCopyFile, this.transferMethod);
        targetCopyFile.enableExecutionPermission();
    }

    public void remove(String host, int port, String[] path) throws ServerException {
        this.checkActive();
        try {
            FileServer targetFS = this.getFileServer(host, port);
            RemoteFile file = this.lookup(targetFS, path);
            this.recursiveRemove(file);
        }
        catch (FileNotFoundException exc) {
            throw new ServerException("A file was not found: " + FileUtils.joinPath((String[])exc.name), exc);
        }
    }

    private void recursiveRemove(RemoteFile file) throws ServerException {
        try {
            if (file.isDirectory()) {
                RemoteFile[] children;
                for (RemoteFile element : children = file.getChildren()) {
                    this.recursiveRemove(element);
                }
            }
            file.remove();
        }
        catch (csfs.remote.ServerException exc) {
            Server.logSevereMessage("Error in CSFS subsystem!", exc);
            throw new ServerException("Remote File Server Exception. message=" + exc.message, exc);
        }
        catch (Exception exc) {
            throw new ServerException("Exception during recursiveRemove operation. exc.getClass().getName()=" + exc.getClass().getName() + " file=" + FileUtils.joinPath((String[])this.getName(exc)), exc);
        }
    }

    public void createDirectory(String host, int port, String[] dir) throws ServerException {
        this.checkActive();
        FileServer targetFS = this.getFileServer(host, port);
        this.lookupOrCreate(targetFS, dir, true);
    }

    private RemoteFile lookup(FileServer fs, String[] path) throws FileNotFoundException, ServerException {
        RemoteFile response;
        if (fs == null) {
            Server.logWarningMessage("Trying to lookup a file in a null file system");
            throw new ServerException("It is not possible to lookup a path in a null file server reference!");
        }
        try {
            response = fs.getRoot().getChild(path);
        }
        catch (FileNotFoundException exc) {
            throw exc;
        }
        catch (csfs.remote.ServerException exc) {
            Server.logSevereMessage("Error in CSFS subsystem!", exc);
            throw new ServerException("Remote File Server Exception. message=" + exc.message, exc);
        }
        catch (Exception exc) {
            throw new ServerException("Exception during lookup operation. exc.getClass().getName()=" + exc.getClass().getName() + " file=" + FileUtils.joinPath((String[])this.getName(exc)), exc);
        }
        return response;
    }

    private RemoteFile lookupOrCreate(FileServer fs, String[] path, boolean directory) throws ServerException {
        RemoteFile response = null;
        try {
            response = this.lookup(fs, path);
            if (response.isDirectory() != directory) {
                throw new ServerException("type mismatch. path=" + path + " response.isDirectory()=" + response.isDirectory() + " expected=" + directory);
            }
        }
        catch (FileNotFoundException e) {
            try {
                response = directory ? fs.getRoot().createDirectory(path) : fs.getRoot().createFile(path);
            }
            catch (csfs.remote.ServerException exc) {
                Server.logSevereMessage("Error in CSFS subsystem!", exc);
                throw new ServerException("Remote File Server Exception. message=" + exc.message, exc);
            }
            catch (Exception exc) {
                throw new ServerException("Exception during lookupOrCreate operation. exc.getClass().getName()=" + exc.getClass().getName() + " file=" + FileUtils.joinPath((String[])this.getName(exc)), exc);
            }
        }
        catch (csfs.remote.ServerException exc) {
            Server.logSevereMessage("Error in CSFS subsystem!", exc);
            throw new ServerException("Remote File Server Exception. message=" + exc.message, exc);
        }
        catch (Exception exc) {
            throw new ServerException("Exception during lookupOrCreate operation. exc.getClass().getName()=" + exc.getClass().getName() + " file=" + FileUtils.joinPath((String[])this.getName(exc)), exc);
        }
        return response;
    }

    private String[] getName(Exception exc) {
        String[] name = null;
        try {
            Field f = exc.getClass().getDeclaredField("name");
            name = (String[])f.get(exc);
        }
        catch (Exception e) {
            name = new String[]{"unspecified"};
        }
        return name;
    }
}

