/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.notificationservice;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class NotificationServiceExecutor
extends ThreadPoolExecutor {
    private final boolean gatherStats;
    private Map<Runnable, Long> durations;
    private long weightedMaxRuntime;
    private long weightedMinRuntime;
    private long absoluteMaxRuntime;
    private long absoluteMinRuntime;
    private AtomicInteger executions;
    private AtomicInteger faults;
    private static ThreadLocal<Integer> executionWeight = new ThreadLocal();

    void setExecutionWeight(int weight) {
        executionWeight.set(weight);
    }

    synchronized long getWeightedMaxRuntime() {
        return this.weightedMaxRuntime;
    }

    synchronized long getWeightedMinRuntime() {
        return this.weightedMinRuntime;
    }

    synchronized long getAbsoluteMaxRuntime() {
        return this.absoluteMaxRuntime;
    }

    synchronized long getAbsoluteMinRuntime() {
        return this.absoluteMinRuntime;
    }

    int getExecutions() {
        return this.executions.intValue();
    }

    int getFaults() {
        return this.faults.intValue();
    }

    NotificationServiceExecutor(boolean gatherStats, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.gatherStats = gatherStats;
        this.reset();
    }

    void reset() {
        this.durations = new Hashtable<Runnable, Long>();
        this.weightedMaxRuntime = 0L;
        this.weightedMinRuntime = Long.MAX_VALUE;
        this.absoluteMaxRuntime = 0L;
        this.absoluteMinRuntime = Long.MAX_VALUE;
        this.executions = new AtomicInteger(0);
        this.faults = new AtomicInteger(0);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.gatherStats) {
            executionWeight.set(1);
            this.durations.put(r, System.currentTimeMillis());
        }
        super.beforeExecute(t, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (this.gatherStats) {
            Long t0 = this.durations.remove(r);
            if (t0 == null) {
                this.faults.incrementAndGet();
            } else {
                long dt = System.currentTimeMillis() - t0;
                int weight = executionWeight.get();
                NotificationServiceExecutor notificationServiceExecutor = this;
                synchronized (notificationServiceExecutor) {
                    this.weightedMaxRuntime = Math.max(this.weightedMaxRuntime, dt / (long)weight);
                    this.weightedMinRuntime = Math.min(this.weightedMinRuntime, dt / (long)weight);
                    this.absoluteMaxRuntime = Math.max(this.absoluteMaxRuntime, dt);
                    this.absoluteMinRuntime = Math.min(this.absoluteMinRuntime, dt);
                }
            }
            this.executions.incrementAndGet();
        }
        super.afterExecute(r, t);
    }
}

