/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.openbus;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.openbusservice.OpenBusService;
import java.util.Locale;

public class ConnectionValidation
implements Validation {
    public static final String NAME = "ConnectionValidation";

    @Override
    public ValidationStatus check(Locale locale) {
        if (OpenBusService.getInstance().isConnected()) {
            return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.openbusmonitor.connection.success", locale));
        }
        return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.openbusmonitor.connection.error", locale), MessageTranslator.getDetailMessage(OpenBusService.getInstance().getOpenbusStatus().getException(), locale));
    }

    @Override
    public String id() {
        return NAME;
    }

    @Override
    public String[] requires() {
        return new String[]{"OpenbusServiceAvailable"};
    }
}

