package csbase.server.services.openbusservice;

import java.util.Properties;

/**
 * 
 * Implementa ofertas de servios para publicao no Openbus.
 * 
 * @author Tecgraf PUC-Rio
 */
public interface OpenBusServiceOffer {

  /**
   * Registra as fbricas necessrias a essa oferta de servio
   */
  public void registerFactories();

  /**
   * Retorna a lista das facetas referentes as ofertas de servio
   * 
   * @return a lista das facetas
   */
  public OpenBusServiceFacet[] getFacets();

  /**
   * Retorna a lista das propriedades referentes a oferta de servio
   * 
   * @return a lista das propriedades da oferta de servio
   */
  public Properties getProperties();
}
