/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_02;

import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.DataValidation;
import csbase.server.services.projectservice.v1_02.ProjectDataService;
import tecgraf.openbus.data_service.core.v1_02.AbsentViews;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataAlreadyExist;
import tecgraf.openbus.data_service.core.v1_02.DataDescription;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalManagementDataServicePOA;
import tecgraf.openbus.data_service.hierarchical.v1_02.InvalidContainer;
import tecgraf.openbus.data_service.hierarchical.v1_02.InvalidPrototype;
import tecgraf.openbus.data_service.hierarchical.v1_02.UnsupportedOperation;

public class IHierarchicalManagementDataServiceServant
extends IHierarchicalManagementDataServicePOA {
    public byte[] copyData(byte[] fSourceKey, byte[] fParentKey) throws ServiceFailure, DataAlreadyExist, DataNotFound, DataAccessDenied, UnsupportedOperation, InvalidDataKey, InvalidContainer {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            byte[] byArray = service.copyData(fSourceKey, fParentKey);
            return byArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public byte[] createData(DataDescription fPrototype, byte[] fParentKey) throws InvalidPrototype, ServiceFailure, DataAlreadyExist, DataNotFound, DataAccessDenied, UnsupportedOperation, InvalidDataKey, InvalidContainer {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            byte[] byArray = service.createData(fPrototype, fParentKey);
            return byArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void deleteData(byte[] fKey) throws ServiceFailure, DataNotFound, DataAccessDenied, UnsupportedOperation, InvalidDataKey {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            service.deleteData(fKey);
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void moveData(byte[] fKey, byte[] fNewParentKey) throws ServiceFailure, DataAlreadyExist, DataNotFound, DataAccessDenied, UnsupportedOperation, InvalidDataKey, InvalidContainer {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            service.moveData(fKey, fNewParentKey);
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public void updateData(byte[] fKey, byte[] fSourceKey) throws ServiceFailure, DataNotFound, DataAccessDenied, AbsentViews, UnsupportedOperation, InvalidDataKey {
        DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            service.updateData(fKey, fSourceKey);
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }
}

