/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice;

import csbase.server.services.restservice.RestService;
import ibase.common.RestErrorMessage;
import ibase.common.ServiceAdapter;
import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.ParseException;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.hk2.api.ServiceLocator;

@Priority(value=1000)
public class CSBaseRequestFilter
implements ContainerRequestFilter {
    @Context
    private ServiceLocator serviceLocator;
    @Context
    private UriInfo uriInfo;
    public static String LOCALE_PARAM = "locale";

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ServiceAdapter.setServiceLocator((ServiceLocator)this.serviceLocator);
        ServiceAdapter.setURI((String)RestService.getInstance().getExternalURL());
        if (requestContext.getUriInfo().getPath().indexOf("authentication") < 0 && requestContext.getUriInfo().getPath().indexOf("links") < 0 && requestContext.getUriInfo().getPath().indexOf("swagger.yaml") < 0 && requestContext.getUriInfo().getPath().indexOf("swagger.json") < 0) {
            String authorizationHeader = requestContext.getHeaderString("Authorization");
            ServiceAdapter.setAuthorizationHeader((String)authorizationHeader);
            if (authorizationHeader == null || !authorizationHeader.startsWith("Bearer ")) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)new RestErrorMessage("Authorization header must be provided")).build());
                return;
            }
            String token = authorizationHeader.substring("Bearer".length()).trim();
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)Locale.getDefault().toString());
            try {
                String userId = authenticationService.parserToken(token, null);
                ServiceAdapter.setCurrentUser((String)userId);
                requestContext.setProperty("userId", (Object)userId);
            }
            catch (ParseException e) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
    }
}

