package csbase.server.services.schedulerservice.classadpolicies;

import java.util.LinkedList;
import java.util.List;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.heuristic.ResourceControllerInterface;

public class ClassAdResourceController implements ResourceControllerInterface {
	
	ClassAdManager manager = new ClassAdManager();

	@Override
	public SGASet simulateResourceConsumption(CommandInfo cmd, SGASet server) {
		SGASet updatedSGA = ClassAdPolicyCommons.simulateResourceConsumption(cmd, server);
		manager.alterSGAAd(updatedSGA);
		return updatedSGA;
	}

	@Override
	public SGASet undoResourceConsumptionSimulation(CommandInfo cmd,
			SGASet server) {
		SGASet updatedSGA = ClassAdPolicyCommons.simulateResourceRelease(cmd, server);
		manager.alterSGAAd(updatedSGA);
		return updatedSGA;
	}

	@Override
	public List<SGASet> getServersThatMeetsRequirements(CommandInfo cmd,
			List<SGASet> servers) {
		List<SGASet> matchedSGAs = new LinkedList<SGASet>();
		List<ClassAdMatchInfo> infos = ClassAdPolicyCommons.getMatchedAds(cmd, servers, manager);
		for(ClassAdMatchInfo info:infos)
			matchedSGAs.add(info.getSGA());
		return matchedSGAs;
	}

	@Override
	public List<CommandInfo> getPossibleCommands(List<CommandInfo> commands, SGASet server) {
		List<ClassAdMatchInfo> matches = ClassAdPolicyCommons.getMatchedAds(commands, server, manager);
		List<CommandInfo> cmds = new LinkedList<CommandInfo>();
		for (ClassAdMatchInfo info:matches)
			cmds.add(info.getCommand());
		return cmds;
	}

}
