/*
 * $Id: ServiceUtils.java 176168 2016-09-22 21:12:51Z fpina $
 */
package csbase.server.services.xmlconversionservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * Mtodos utilitrios para o servio de converso XML.
 */
public class ServiceUtils {
  /**
   * L apenas os dados de um arquivo de dados XML (sem o marcador de final de
   * entrada). A leitura  encerrada aps o marcador de fim dos dados de entrada
   * ser lido, ou se ele for null, at o final do arquivo. O canal de entrada
   * recebido  sempre fechado ao trmino da operao, mesmo que ocorra algum
   * erro.
   *
   *
   * @param in Stream de entrada de dados.
   * @param xmlEndMarker - marcador de final de XML, no caso de o arquivo conter
   *        algo a mais do que XML. Se for null, vai ler inputStream todo
   * @return String contendo o XML correspondente aos dados de entrada, sem o
   *         marcador de final de entrada
   * @throws IOException se houver algum erro de I/O durante o processamento.
   *
   */
  public static String readXMLAsString(InputStream in,
    String xmlEndMarker) throws IOException {
    StringBuffer buffer = new StringBuffer();
    try (BufferedReader reader =
           new BufferedReader(new InputStreamReader(in))) {
      String line = reader.readLine();
      while (line != null) {
        // no inclui o marcador de final de entrada na string retornada
        if (xmlEndMarker != null && xmlEndMarker.equals(line)) {
          break;
        }
        buffer.append(line);
        buffer.append('\n');
        line = reader.readLine();
      }
    }
    return buffer.toString();
  }
}
