/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.Permission;
import csbase.server.services.administrationservice.DAOException;
import csbase.server.services.administrationservice.PermissionDAO;
import csbase.server.services.administrationservice.PermissionIO;
import java.util.List;

public class DefaultPermissionDAO
implements PermissionDAO {
    private final PermissionIO permissionRepository = new PermissionIO();

    @Override
    public Permission createPermission(Permission permission) throws DAOException {
        Permission result;
        try {
            result = this.permissionRepository.writeNew(permission);
        }
        catch (Exception e) {
            throw new DAOException(e, permission.toString());
        }
        if (result == null) {
            throw new DAOException("Falha em PermissionIO.writeNew", permission.toString());
        }
        return result;
    }

    @Override
    public void deletePermission(Object id) throws DAOException {
        try {
            this.permissionRepository.delete(id);
        }
        catch (Exception e) {
            throw new DAOException(e, "id: " + id);
        }
    }

    @Override
    public Permission modifyPermission(Object id, Permission permission) throws DAOException {
        Permission result;
        try {
            result = this.permissionRepository.write(id, permission);
        }
        catch (Exception e) {
            throw new DAOException(e, permission.toString());
        }
        if (result == null) {
            throw new DAOException("Falha em PermissionIO.write", permission.toString() + " - para o usu\u00e1rio: " + id);
        }
        return result;
    }

    @Override
    public List<Permission> readAllPermissions() throws DAOException {
        return this.permissionRepository.readAll();
    }

    @Override
    public Permission readPermission(Object id) throws DAOException {
        try {
            return this.permissionRepository.read(id);
        }
        catch (Exception e) {
            throw new DAOException(e, "id: " + id);
        }
    }
}

