/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.dbmanagerservice;

import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.services.dbmanagerservice.Pool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.LinkedList;

public final class DBPool
extends Pool {
    private int userPasswordErrorCode;
    private int freeConnections;
    private int maxConnections;
    private int maxUseTimes;
    private long decayTime;
    private long delayBetweenOpen;
    private long connectionTimeout;
    private int numConnections;
    private int usedConnections;
    private LinkedList<ConnectionData> pool;
    private Hashtable<Connection, ConnectionData> using;
    private PoolMonitor poolMonitor;
    private boolean moduleClosing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPassword(String passwd) {
        if (passwd == null) {
            throw new IllegalArgumentException("password == null");
        }
        if (!this.password.equals(passwd)) {
            Server.logInfoMessage("Houve mudan\u00e7a de senha.");
            this.setPassword(passwd);
            Cloneable cloneable = this.pool;
            synchronized (cloneable) {
                Server.logInfoMessage("Removendo " + this.pool.size() + " conex\u00f5es inv\u00e1lidas do pool..");
                while (!this.pool.isEmpty()) {
                    ConnectionData connData = this.pool.removeFirst();
                    try {
                        connData.conn.commit();
                        connData.conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        --this.numConnections;
                    }
                }
            }
            cloneable = this.using;
            synchronized (cloneable) {
                Server.logInfoMessage("Invalidando " + this.using.values().size() + " conex\u00f5es em uso para serem descartadas..");
                for (ConnectionData connData : this.using.values()) {
                    connData.invalid = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Server.logInfoMessage("POOL " + this.name + ": terminando...");
        LinkedList<ConnectionData> linkedList = this.pool;
        synchronized (linkedList) {
            this.moduleClosing = true;
            this.maxConnections = 0;
            while (this.numConnections > 0) {
                ConnectionData data = this.internalGetConnection();
                if (data == null) continue;
                this.disposeConnection(data.conn);
            }
        }
        Server.logInfoMessage("POOL " + this.name + ": terminado.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        LinkedList<ConnectionData> linkedList = this.pool;
        synchronized (linkedList) {
            try {
                conn.commit();
                conn.close();
            }
            catch (SQLException e) {
                Server.logSevereMessage("POOL " + this.name + ": Erro em disposeConnection", e);
            }
            finally {
                --this.numConnections;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() {
        LinkedList<ConnectionData> linkedList = this.pool;
        synchronized (linkedList) {
            if (this.moduleClosing) {
                return null;
            }
            ConnectionData data = this.internalGetConnection();
            if (data == null) {
                return null;
            }
            data.inUseTime = System.currentTimeMillis();
            this.using.put(data.conn, data);
            this.usedConnections = Math.max(this.usedConnections, this.numConnections - this.pool.size());
            this.pool.notifyAll();
            return data.conn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        this.numConnections = 0;
        this.usedConnections = 0;
        this.pool = new LinkedList();
        this.using = new Hashtable();
        this.moduleClosing = false;
        Connection conn = null;
        try {
            Class.forName(this.driver);
            conn = this.getConnection();
            if (conn == null) {
                Server.logInfoMessage("POOL " + this.name + ": Erro na conex\u00e3o com a base.");
                boolean bl = false;
                return bl;
            }
        }
        catch (ClassNotFoundException e) {
            Server.logSevereMessage("POOL " + this.name + ": Erro na carga do driver " + this.driver, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.releaseConnection(conn, null, null);
            }
        }
        this.poolMonitor = new PoolMonitor();
        this.poolMonitor.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionData internalGetConnection() {
        LinkedList<ConnectionData> linkedList = this.pool;
        synchronized (linkedList) {
            if (!this.pool.isEmpty()) {
                return this.pool.removeFirst();
            }
            if (this.numConnections < this.maxConnections) {
                Server.logInfoMessage("POOL " + this.name + ": Criando conex\u00e3o por demanda.");
                return this.newConnection();
            }
            if (this.pool.isEmpty() && this.numConnections > 0) {
                try {
                    Server.logInfoMessage("POOL " + this.name + ": Aguardando por conex\u00e3o (timeout = " + this.connectionTimeout + ")");
                    this.pool.wait(this.connectionTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.pool.isEmpty()) {
                Server.logInfoMessage("POOL " + this.name + ": Recuperando conex\u00e3o do pool.");
                return this.pool.removeFirst();
            }
            if (this.numConnections < this.maxConnections) {
                Server.logInfoMessage("POOL " + this.name + ": Criando conex\u00e3o por demanda.");
                return this.newConnection();
            }
        }
        return null;
    }

    private ConnectionData newConnection() {
        long initialTime = System.currentTimeMillis();
        while (true) {
            try {
                Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
                if (conn != null) {
                    ++this.numConnections;
                    return new ConnectionData(conn);
                }
            }
            catch (SQLException e) {
                Server.logSevereMessage("POOL " + this.name + ": Erro na obten\u00e7\u00e3o de uma conex\u00e3o", e);
                if (e.getErrorCode() == this.userPasswordErrorCode) break;
            }
            if (System.currentTimeMillis() - initialTime > this.connectionTimeout) break;
            try {
                Thread.sleep(this.delayBetweenOpen);
            }
            catch (InterruptedException e) {
                Server.logSevereMessage("POOL " + this.name + ": N\u00e3o deveria ocorrer", e);
            }
        }
        return null;
    }

    private String printTime(long t) {
        if (t < 1000L) {
            return t + " milisegundo" + (t == 1L ? "" : "s");
        }
        float time = (float)t / 1000.0f;
        if (time < 60.0f) {
            return time + " segundo" + (time == 1.0f ? "" : "s");
        }
        if ((time /= 60.0f) < 60.0f) {
            return time + " minuto" + (time == 1.0f ? "" : "s");
        }
        if ((time /= 60.0f) < 24.0f) {
            return time + " hora" + (time == 1.0f ? "" : "s");
        }
        return (time /= 24.0f) + " dia" + (time == 1.0f ? "" : "s");
    }

    @Override
    public void releaseConnection(Connection conn, Statement st, ResultSet rs) {
        this.releaseConnection(conn, st, rs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(Connection conn, Statement st, ResultSet rs, boolean dispose) {
        LinkedList<ConnectionData> e4;
        boolean ok = false;
        try {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    Server.logSevereMessage("POOL " + this.name + ": close - rs", e2);
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e3) {
                    Server.logSevereMessage("POOL " + this.name + ": close - st", e3);
                }
            }
            if (conn != null) {
                try {
                    conn.commit();
                    conn.setAutoCommit(true);
                    ok = true;
                }
                catch (SQLException e4) {
                    Server.logSevereMessage("POOL " + this.name + ": close - conn", e4);
                }
            }
            e4 = this.pool;
        }
        catch (Throwable t) {
            LinkedList<ConnectionData> linkedList;
            try {
                Server.logSevereMessage("POOL " + this.name + ": close", t);
                linkedList = this.pool;
            }
            catch (Throwable throwable) {
                LinkedList<ConnectionData> linkedList2 = this.pool;
                synchronized (linkedList2) {
                    if (conn == null) {
                        Server.logInfoMessage("POOL " + this.name + ": Conex\u00e3o nula devolvida!");
                        return;
                    }
                    ConnectionData data = this.using.get(conn);
                    if (data != null) {
                        data.invalid = dispose;
                        ++data.usedTimes;
                        long t2 = System.currentTimeMillis() - data.inUseTime;
                        this.using.remove(data);
                        if (!ok) {
                            Server.logInfoMessage("POOL " + this.name + ": Fechando conex\u00e3o por erro (usada " + data.usedTimes + " vezes).");
                            this.disposeConnection(conn);
                        } else if (data.usedTimes >= this.maxUseTimes) {
                            t2 = System.currentTimeMillis() - data.creationTime;
                            Server.logInfoMessage("POOL " + this.name + ": Fechando conex\u00e3o j\u00e1 utilizada " + data.usedTimes + " vezes, ao longo de " + this.printTime(t2) + ".");
                            this.disposeConnection(conn);
                        } else if (!data.invalid) {
                            this.pool.add(data);
                        } else {
                            Server.logInfoMessage("Conex\u00e3o foi invalidada. Descartada.");
                            this.disposeConnection(data.conn);
                        }
                    } else {
                        Server.logInfoMessage("POOL " + this.name + ": Conex\u00e3o sem registro!");
                    }
                    this.pool.notifyAll();
                }
                throw throwable;
            }
            synchronized (linkedList) {
                if (conn == null) {
                    Server.logInfoMessage("POOL " + this.name + ": Conex\u00e3o nula devolvida!");
                    return;
                }
                ConnectionData data = this.using.get(conn);
                if (data != null) {
                    data.invalid = dispose;
                    ++data.usedTimes;
                    long t3 = System.currentTimeMillis() - data.inUseTime;
                    this.using.remove(data);
                    if (!ok) {
                        Server.logInfoMessage("POOL " + this.name + ": Fechando conex\u00e3o por erro (usada " + data.usedTimes + " vezes).");
                        this.disposeConnection(conn);
                    } else if (data.usedTimes >= this.maxUseTimes) {
                        t3 = System.currentTimeMillis() - data.creationTime;
                        Server.logInfoMessage("POOL " + this.name + ": Fechando conex\u00e3o j\u00e1 utilizada " + data.usedTimes + " vezes, ao longo de " + this.printTime(t3) + ".");
                        this.disposeConnection(conn);
                    } else if (!data.invalid) {
                        this.pool.add(data);
                    } else {
                        Server.logInfoMessage("Conex\u00e3o foi invalidada. Descartada.");
                        this.disposeConnection(data.conn);
                    }
                } else {
                    Server.logInfoMessage("POOL " + this.name + ": Conex\u00e3o sem registro!");
                }
                this.pool.notifyAll();
            }
        }
        synchronized (e4) {
            if (conn == null) {
                Server.logInfoMessage("POOL " + this.name + ": Conex\u00e3o nula devolvida!");
                return;
            }
            ConnectionData data = this.using.get(conn);
            if (data != null) {
                data.invalid = dispose;
                ++data.usedTimes;
                long t = System.currentTimeMillis() - data.inUseTime;
                this.using.remove(data);
                if (!ok) {
                    Server.logInfoMessage("POOL " + this.name + ": Fechando conex\u00e3o por erro (usada " + data.usedTimes + " vezes).");
                    this.disposeConnection(conn);
                } else if (data.usedTimes >= this.maxUseTimes) {
                    t = System.currentTimeMillis() - data.creationTime;
                    Server.logInfoMessage("POOL " + this.name + ": Fechando conex\u00e3o j\u00e1 utilizada " + data.usedTimes + " vezes, ao longo de " + this.printTime(t) + ".");
                    this.disposeConnection(conn);
                } else if (!data.invalid) {
                    this.pool.add(data);
                } else {
                    Server.logInfoMessage("Conex\u00e3o foi invalidada. Descartada.");
                    this.disposeConnection(data.conn);
                }
            } else {
                Server.logInfoMessage("POOL " + this.name + ": Conex\u00e3o sem registro!");
            }
            this.pool.notifyAll();
        }
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        Server.logInfoMessage("POOL " + this.name + ": connectionTimeout: " + connectionTimeout);
    }

    public void setDecayTime(long decayTime) {
        this.decayTime = decayTime;
        Server.logInfoMessage("POOL " + this.name + ": decayTime: " + decayTime);
    }

    public void setDelayBetweenOpen(long delayBetweenOpen) {
        this.delayBetweenOpen = delayBetweenOpen;
        Server.logInfoMessage("POOL " + this.name + ": delayBetweenOpen: " + delayBetweenOpen);
    }

    @Override
    public void setDriver(String driver) {
        this.driver = driver;
        Server.logInfoMessage("POOL " + this.name + ": driver: " + driver);
    }

    public void setFreeConnections(int freeConnections) {
        this.freeConnections = freeConnections;
        Server.logInfoMessage("POOL " + this.name + ": freeConnections: " + freeConnections);
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        Server.logInfoMessage("POOL " + this.name + ": maxConnections: " + maxConnections);
    }

    public void setMaxUseTimes(int maxUseTimes) {
        this.maxUseTimes = maxUseTimes;
        Server.logInfoMessage("POOL " + this.name + ": maxUseTimes: " + maxUseTimes);
    }

    public void setUserPasswordErrorCode(int userPasswordErrorCode) {
        this.userPasswordErrorCode = userPasswordErrorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOpenCursors(Connection conn) {
        PreparedStatement psQuery = null;
        ResultSet rs = null;
        int openCursors = 0;
        try {
            String sqlQuery = "SELECT a.value FROM v$mystat a, v$statname b WHERE a.statistic# = b.statistic# AND b.name = 'opened cursors current'";
            psQuery = conn.prepareStatement("SELECT a.value FROM v$mystat a, v$statname b WHERE a.statistic# = b.statistic# AND b.name = 'opened cursors current'");
            rs = psQuery.executeQuery();
            if (rs.next()) {
                Object cursor = rs.getObject(1);
                openCursors = Integer.parseInt(cursor.toString()) - 1;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (psQuery != null) {
                    psQuery.close();
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return openCursors;
    }

    public DBPool(String name) throws ServerException {
        super(name);
        this.setFreeConnections(this.getIntProperty("freeConnections"));
        this.setMaxConnections(this.getIntProperty("maxConnections"));
        this.setMaxUseTimes(this.getIntProperty("maxUseTimes"));
        this.setDecayTime(this.getLongProperty("decayTime"));
        this.setDelayBetweenOpen(this.getLongProperty("delayBetweenOpen"));
        this.setConnectionTimeout(this.getLongProperty("connectionTimeout"));
        this.setUserPasswordErrorCode(this.getIntProperty("userPasswordErrorCode"));
    }

    private class PoolMonitor
    extends Thread {
        private PoolMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Server.logInfoMessage("Thread iniciada: PoolMonitor");
            LinkedList linkedList = DBPool.this.pool;
            synchronized (linkedList) {
                long lastDecayTime = 0L;
                while (!DBPool.this.moduleClosing) {
                    long waitTime;
                    if (DBPool.this.pool.size() < DBPool.this.freeConnections && DBPool.this.numConnections < DBPool.this.maxConnections) {
                        Server.logInfoMessage("POOL " + DBPool.this.name + ": Criando conex\u00e3o extra.");
                        ConnectionData data = DBPool.this.newConnection();
                        if (data != null) {
                            DBPool.this.pool.add(data);
                        }
                        waitTime = DBPool.this.delayBetweenOpen;
                    } else {
                        long now = System.currentTimeMillis();
                        if (now - lastDecayTime > DBPool.this.decayTime) {
                            int spareConnections = (int)Math.ceil((float)(DBPool.this.numConnections - DBPool.this.usedConnections) / 2.0f);
                            int eligibleConnections = DBPool.this.pool.size() - DBPool.this.freeConnections;
                            spareConnections = Math.max(0, Math.min(spareConnections, eligibleConnections));
                            for (int i = 0; i < spareConnections; ++i) {
                                ConnectionData data = (ConnectionData)DBPool.this.pool.removeFirst();
                                DBPool.this.disposeConnection(data.conn);
                            }
                            Server.logInfoMessage("POOL " + DBPool.this.name + ": usadas=" + DBPool.this.usedConnections + " fechadas=" + spareConnections + " restaram=" + DBPool.this.numConnections);
                            lastDecayTime = System.currentTimeMillis();
                            DBPool.this.usedConnections = 0;
                            waitTime = DBPool.this.decayTime;
                        } else {
                            waitTime = DBPool.this.decayTime - (now - lastDecayTime);
                        }
                    }
                    try {
                        DBPool.this.pool.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        Server.logSevereMessage("POOL " + DBPool.this.name + ": Erro no PoolMonitor - run", e);
                    }
                }
            }
            Server.logInfoMessage("Thread terminada: PoolMonitor");
        }
    }

    private class ConnectionData {
        Connection conn;
        long creationTime;
        long inUseTime;
        int usedTimes;
        boolean invalid = false;

        ConnectionData(Connection conn) {
            this.conn = conn;
            this.creationTime = System.currentTimeMillis();
            this.usedTimes = 0;
        }
    }
}

