/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectsynchronizationservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.ClientProjectFile;
import csbase.logic.ClientProjectFileInfo;
import csbase.logic.CommonClientProject;
import csbase.logic.EncryptedPassword;
import csbase.logic.LoginPasswordCipher;
import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationFileInfo;
import csbase.logic.ProjectSynchronizationListProjects;
import csbase.logic.ProjectSynchronizationResult;
import csbase.logic.ProjectSynchronizationUnit;
import csbase.logic.Session;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.filters.ProjectFileNameFilter;
import csbase.remote.ProjectServiceInterface;
import csbase.remote.ProjectSynchronizationMonitor;
import csbase.remote.ProjectSynchronizationServiceInterface;
import csbase.remote.ServerEntryPoint;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.projectservice.ProjectService;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.logic.RemoteFileChannel;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

public class ProjectSynchronizationService
extends Service
implements ProjectSynchronizationServiceInterface {
    protected ProjectSynchronizationService() throws ServerException {
        super("ProjectSynchronizationService");
    }

    public static void createService() throws ServerException {
        new ProjectSynchronizationService();
    }

    public static ProjectSynchronizationService getInstance() {
        return (ProjectSynchronizationService)ProjectSynchronizationService.getInstance("ProjectSynchronizationService");
    }

    @Override
    public void initService() throws ServerException {
    }

    @Override
    public void shutdownService() throws ServerException {
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    private void addFileInfo(ProjectServiceInterface service, ClientProjectFile node, Map<String, ProjectSynchronizationFileInfo> map) throws RemoteException {
        if (this.acceptFileFilters(node)) {
            return;
        }
        if (node.isDirectory()) {
            ClientProjectFile[] children = service.getChildren(node.getProjectId(), node.getPath());
            for (int i = 0; i < children.length; ++i) {
                this.addFileInfo(service, children[i], map);
            }
        } else {
            ClientProjectFileInfo cpfi = new ClientProjectFileInfo(node.getType(), node.size(), node.getModificationDate(), node.isUnderConstruction(), node.isLocked());
            ProjectSynchronizationFileInfo psfi = new ProjectSynchronizationFileInfo(cpfi, node.getPath(), false);
            map.put(psfi.generateAbsoluteFilename(), psfi);
        }
    }

    private Map<String, ProjectSynchronizationFileInfo> getAllFileInfos(ProjectServiceInterface service, Object projectId) {
        try {
            CommonClientProject project = service.openProject(projectId, true);
            if (project == null) {
                throw new ServiceFailureException("Projeto inexistente: " + projectId);
            }
            ClientProjectFile root = project.getRoot();
            HashMap<String, ProjectSynchronizationFileInfo> map = new HashMap<String, ProjectSynchronizationFileInfo>();
            this.addFileInfo(service, root, map);
            service.closeProject(project.getId(), true);
            return map;
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("ProjectSynchronizationService.error.rmi"), (Throwable)e);
        }
    }

    private LoginInfo remoteLogin(String serverName, String login, String password) {
        LoginInfo loginInfo = new LoginInfo();
        if (serverName == null) {
            loginInfo.projectService = ProjectService.getInstance();
            return loginInfo;
        }
        try {
            String url = "rmi://" + serverName + "/" + "Server";
            try {
                loginInfo.server = (ServerEntryPoint)Naming.lookup(url);
            }
            catch (Exception e) {
                loginInfo.server = null;
            }
            if (loginInfo.server == null) {
                String errorMsg = this.getString("ProjectSynchronizationService.error.invalid.server");
                errorMsg = MessageFormat.format(errorMsg, serverName);
                throw new ServiceFailureException(errorMsg);
            }
            Object key = Service.getKey();
            Locale locale = LoginService.getInstance().getUserSessionLocale(key);
            loginInfo.serverName = serverName;
            PublicKey publicKey = LoginService.getInstance().getPublicKey();
            EncryptedPassword encryptedPassword = LoginPasswordCipher.encrypt((String)password, (PublicKey)publicKey);
            loginInfo.session = loginInfo.server.login(login, encryptedPassword, locale);
            if (loginInfo.session == null) {
                String errorMsg = this.getString("ProjectSynchronizationService.error.invalid.user.password");
                throw new ServiceFailureException(errorMsg);
            }
            loginInfo.projectService = (ProjectServiceInterface)loginInfo.server.fetchService(loginInfo.session.getKey(), "ProjectService");
            return loginInfo;
        }
        catch (Exception e) {
            String errorMsg = this.getString("ProjectSynchronizationService.error");
            errorMsg = MessageFormat.format(errorMsg, serverName);
            if (e instanceof ServiceFailureException && e.getMessage() != null && !e.getMessage().isEmpty()) {
                errorMsg = errorMsg + " " + e.getMessage();
            }
            throw new ServiceFailureException(errorMsg, (Throwable)e);
        }
    }

    private void remoteLogout(LoginInfo loginInfo) {
        try {
            if (loginInfo.server != null) {
                loginInfo.server.logout(loginInfo.session.getKey());
            }
        }
        catch (Exception e) {
            String errorMsg = this.getString("ProjectSynchronizationService.error.close.connection");
            errorMsg = MessageFormat.format(errorMsg, loginInfo.serverName);
            throw new ServiceFailureException(errorMsg, (Throwable)e);
        }
    }

    private void adjustTransfer(Map<String, ProjectSynchronizationFileInfo> mA, Map<String, ProjectSynchronizationFileInfo> mB) {
        for (String fileName : mA.keySet()) {
            ProjectSynchronizationFileInfo i1 = mA.get(fileName);
            ProjectSynchronizationFileInfo i2 = mB.get(fileName);
            if (i2 != null && (i1.getClientFileInfo().getModificationDate() <= i2.getClientFileInfo().getModificationDate() || i2.getClientFileInfo().isUnderConstruction())) continue;
            i1.setTransfer(true);
            i1.setNewFile(true);
        }
    }

    public ProjectSynchronizationData buildTransferMaps(ProjectSynchronizationData data) {
        ProjectSynchronizationUnit unitA = data.getUnitA();
        ProjectSynchronizationUnit unitB = data.getUnitB();
        if (unitA.getProjectId() == null) {
            throw new ServiceFailureException("Projeto de origem nulo.");
        }
        if (unitB.getProjectId() == null) {
            throw new ServiceFailureException("Projeto de destino nulo.");
        }
        LoginInfo loginInfo = this.remoteLogin(unitA.getServer(), unitA.getLogin(), unitA.getPassword());
        Map<String, ProjectSynchronizationFileInfo> mapA = this.getAllFileInfos(loginInfo.projectService, unitA.getProjectId());
        this.remoteLogout(loginInfo);
        loginInfo = this.remoteLogin(unitB.getServer(), unitB.getLogin(), unitB.getPassword());
        Map<String, ProjectSynchronizationFileInfo> mapB = this.getAllFileInfos(loginInfo.projectService, unitB.getProjectId());
        this.remoteLogout(loginInfo);
        this.adjustTransfer(mapA, mapB);
        this.adjustTransfer(mapB, mapA);
        unitA.setFiles(mapA);
        unitB.setFiles(mapB);
        return data;
    }

    public ProjectSynchronizationListProjects buildListProjects(ProjectSynchronizationData data) {
        ProjectSynchronizationUnit unitA = data.getUnitA();
        ProjectSynchronizationUnit unitB = data.getUnitB();
        try {
            LoginInfo loginInfo = this.remoteLogin(unitA.getServer(), unitA.getLogin(), unitA.getPassword());
            List listA = loginInfo.projectService.getProjectsFromUser(unitA.getProjectOwnerId());
            Collections.sort(listA);
            this.remoteLogout(loginInfo);
            loginInfo = this.remoteLogin(unitB.getServer(), unitB.getLogin(), unitB.getPassword());
            List listB = loginInfo.projectService.getProjectsFromUser(unitB.getProjectOwnerId());
            Collections.sort(listB);
            this.remoteLogout(loginInfo);
            ProjectSynchronizationListProjects pslp = new ProjectSynchronizationListProjects(listA, listB);
            return pslp;
        }
        catch (RemoteException e) {
            throw new ServiceFailureException("Erro ao obter os projetos.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void transfer(RemoteFileChannelInfo channelFrom, RemoteFileChannelInfo channelTo, Monitor monitor) throws CancelledException, Exception {
        block25: {
            Throwable err;
            SyncRemoteFileChannel rfcto;
            SyncRemoteFileChannel rfcfrom;
            block23: {
                rfcfrom = null;
                rfcto = null;
                err = null;
                rfcfrom = new SyncRemoteFileChannel(channelFrom.getIdentifier(), false, channelFrom.getHost(), channelFrom.getPort(), channelFrom.getKey());
                rfcfrom.open(true);
                rfcto = new SyncRemoteFileChannel(channelTo.getIdentifier(), true, channelTo.getHost(), channelTo.getPort(), channelTo.getKey());
                rfcto.open(false);
                long size = rfcfrom.getSize();
                rfcfrom.syncTransferTo(0L, size, (RemoteFileChannel)rfcto);
                rfcto.setSize(size);
                if (rfcto == null) break block23;
                try {
                    rfcto.close();
                }
                catch (FailureException e) {
                    Throwable throwable = err = err == null ? e : err;
                }
            }
            if (rfcfrom != null) {
                try {
                    rfcfrom.close();
                }
                catch (FailureException e) {
                    Throwable throwable = err = err == null ? e : err;
                }
            }
            if (err != null) {
                throw err;
            }
            break block25;
            catch (Exception e) {
                block24: {
                    try {
                        err = e;
                        if (rfcto == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (rfcto != null) {
                            try {
                                rfcto.close();
                            }
                            catch (FailureException e2) {
                                Throwable throwable2 = err = err == null ? e2 : err;
                            }
                        }
                        if (rfcfrom != null) {
                            try {
                                rfcfrom.close();
                            }
                            catch (FailureException e3) {
                                Throwable throwable3 = err = err == null ? e3 : err;
                            }
                        }
                        if (err != null) {
                            throw err;
                        }
                        throw throwable;
                    }
                    try {
                        rfcto.close();
                    }
                    catch (FailureException e4) {
                        Throwable throwable = err = err == null ? e4 : err;
                    }
                }
                if (rfcfrom != null) {
                    try {
                        rfcfrom.close();
                    }
                    catch (FailureException e5) {
                        Throwable throwable = err = err == null ? e5 : err;
                    }
                }
                if (err != null) {
                    throw err;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void copyFiles(ProjectServiceInterface serviceFrom, CommonClientProject projectFrom, ProjectServiceInterface serviceTo, CommonClientProject projectTo, Map<String, ProjectSynchronizationFileInfo> fileInfos, List<String> results, Monitor monitor) {
        Iterator<String> it = fileInfos.keySet().iterator();
        while (it.hasNext() && !monitor.isCancelled()) {
            String result;
            ClientProjectFile toFile;
            long modificationDate;
            boolean fileCreated;
            String backupName;
            String fileName;
            ProjectSynchronizationFileInfo fileInfo;
            block21: {
                block20: {
                    String key = it.next();
                    fileInfo = fileInfos.get(key);
                    if (!fileInfo.getTransfer()) continue;
                    fileName = fileInfo.getFilename();
                    backupName = null;
                    fileCreated = false;
                    modificationDate = fileInfo.getClientFileInfo().getModificationDate();
                    toFile = this.findFile(serviceTo, projectTo.getRoot(), fileInfo.getAbsoluteFilename());
                    if (toFile == null || !toFile.isDirectory()) break block20;
                    String msg = "O projeto " + projectTo.getName() + " possui um diret\u00f3rio com o mesmo nome que " + fileName;
                    monitor.partialResult(fileInfo.getAbsoluteFilename(), msg);
                    results.add(msg);
                    if (backupName == null) continue;
                    String[] delete = (String[])fileInfo.getAbsoluteFilename().clone();
                    int index = delete.length - 1;
                    delete[index] = backupName;
                    try {
                        serviceTo.removeFile(projectTo.getId(), delete);
                    }
                    catch (Exception e) {
                        String result2 = "Falha na remo\u00e7\u00e3o de arquivo de backup: " + delete[index] + " - " + e;
                        monitor.partialResult(delete, result2);
                        results.add(result2);
                    }
                    continue;
                }
                ClientProjectFile toDir = this.findFile(serviceTo, projectTo.getRoot(), fileInfo.getAbsoluteDirPath());
                if (toDir == null) {
                    serviceTo.createDirectory(projectTo.getId(), fileInfo.getAbsoluteDirPath());
                    break block21;
                }
                if (toDir.isDirectory()) break block21;
                String msg = "O projeto " + projectTo.getName() + " possui um arquivo com o mesmo nome que o diret\u00f3rio " + toDir.getName();
                monitor.partialResult(fileInfo.getAbsoluteFilename(), msg);
                results.add(msg);
                if (backupName == null) continue;
                String[] delete = (String[])fileInfo.getAbsoluteFilename().clone();
                int index = delete.length - 1;
                delete[index] = backupName;
                try {
                    serviceTo.removeFile(projectTo.getId(), delete);
                }
                catch (Exception e) {
                    String result3 = "Falha na remo\u00e7\u00e3o de arquivo de backup: " + delete[index] + " - " + e;
                    monitor.partialResult(delete, result3);
                    results.add(result3);
                }
                continue;
            }
            if (toFile != null) {
                backupName = this.generateBackupName(serviceTo, projectTo.getRoot(), fileInfo.getAbsoluteFilename());
                serviceTo.renameFile(projectTo.getId(), fileInfo.getAbsoluteFilename(), backupName);
            }
            monitor.initTransfer(fileInfo.getFilename());
            serviceTo.createFile(projectTo.getId(), fileInfo.getAbsoluteDirPath(), fileInfo.getFilename(), fileInfo.getClientFileInfo().getType());
            fileCreated = true;
            String description = serviceFrom.getFileDescription(projectFrom.getId(), fileInfo.getAbsoluteFilename());
            serviceTo.setFileDescription(projectTo.getId(), fileInfo.getAbsoluteFilename(), description);
            RemoteFileChannelInfo channelFrom = serviceFrom.openFileChannel(projectFrom.getId(), fileInfo.getAbsoluteFilename(), true);
            RemoteFileChannelInfo channelTo = serviceTo.openFileChannel(projectTo.getId(), fileInfo.getAbsoluteFilename(), false);
            this.transfer(channelFrom, channelTo, monitor);
            serviceTo.setFileModificationDate(projectTo.getId(), fileInfo.getAbsoluteFilename(), modificationDate);
            monitor.partialResult(fileInfo.getAbsoluteFilename(), null);
            if (backupName == null) continue;
            String[] delete = (String[])fileInfo.getAbsoluteFilename().clone();
            int index = delete.length - 1;
            delete[index] = backupName;
            try {
                serviceTo.removeFile(projectTo.getId(), delete);
            }
            catch (Exception e) {
                result = "Falha na remo\u00e7\u00e3o de arquivo de backup: " + delete[index] + " - " + e;
                monitor.partialResult(delete, result);
                results.add(result);
            }
            continue;
            catch (Exception e) {
                try {
                    String result4 = "Falha na transfer\u00eancia de: " + fileName + " - " + e.getMessage();
                    Server.logSevereMessage(result4, e);
                    monitor.partialResult(fileInfo.getAbsoluteFilename(), result4);
                    results.add(result4);
                    this.tryRecovery(backupName, fileCreated, serviceTo, projectTo, fileInfo, results, monitor);
                    backupName = null;
                    if (backupName == null) continue;
                }
                catch (Throwable throwable) {
                    if (backupName != null) {
                        String[] delete2 = (String[])fileInfo.getAbsoluteFilename().clone();
                        int index2 = delete2.length - 1;
                        delete2[index2] = backupName;
                        try {
                            serviceTo.removeFile(projectTo.getId(), delete2);
                        }
                        catch (Exception e2) {
                            String result5 = "Falha na remo\u00e7\u00e3o de arquivo de backup: " + delete2[index2] + " - " + e2;
                            monitor.partialResult(delete2, result5);
                            results.add(result5);
                        }
                    }
                    throw throwable;
                }
                delete = (String[])fileInfo.getAbsoluteFilename().clone();
                index = delete.length - 1;
                delete[index] = backupName;
                try {
                    serviceTo.removeFile(projectTo.getId(), delete);
                }
                catch (Exception e3) {
                    result = "Falha na remo\u00e7\u00e3o de arquivo de backup: " + delete[index] + " - " + e3;
                    monitor.partialResult(delete, result);
                    results.add(result);
                }
            }
        }
    }

    private void tryRecovery(String backupName, boolean fileCreated, ProjectServiceInterface service, CommonClientProject project, ProjectSynchronizationFileInfo fileInfo, List<String> results, Monitor monitor) {
        try {
            if (fileCreated) {
                service.removeFile(project.getId(), fileInfo.getAbsoluteFilename());
            }
            if (backupName != null) {
                String[] actualFilename = (String[])fileInfo.getAbsoluteFilename().clone();
                actualFilename[actualFilename.length - 1] = backupName;
                service.renameFile(project.getId(), actualFilename, fileInfo.getFilename());
            }
        }
        catch (Exception e) {
            Server.logSevereMessage(e.getMessage() + " - " + project.getName());
            String result = "Falha na recupera\u00e7\u00e3o de: " + fileInfo.getFilename() + " - " + e;
            monitor.partialResult(fileInfo.getAbsoluteFilename(), result);
            results.add(result);
        }
    }

    private boolean existsFile(ProjectServiceInterface service, ClientProjectFile pf, String[] absolutePath) throws RemoteException {
        return service.existsFile(pf.getProjectId(), absolutePath);
    }

    private ClientProjectFile findFile(ProjectServiceInterface service, ClientProjectFile root, String[] path) throws RemoteException {
        ClientProjectFile file = root;
        for (int i = 0; i < path.length; ++i) {
            ClientProjectFile child = service.getChild(root.getProjectId(), file.getPath(), path[i]);
            if (child == null) {
                return null;
            }
            child.setParent(file);
            file = child;
        }
        return file;
    }

    private String generateBackupName(ProjectServiceInterface service, ClientProjectFile pf, String[] absolutePath) throws RemoteException {
        String filename = absolutePath[absolutePath.length - 1];
        String[] path = (String[])absolutePath.clone();
        do {
            long time = System.currentTimeMillis();
            path[path.length - 1] = filename + Long.toString(time);
        } while (this.existsFile(service, pf, path));
        return path[path.length - 1];
    }

    private void transferFiles(ProjectServiceInterface serviceA, ProjectServiceInterface serviceB, ProjectSynchronizationUnit unitA, ProjectSynchronizationUnit unitB, List<String> resultsA, List<String> resultsB, Monitor monitor) {
        try {
            CommonClientProject projectA = serviceA.openProject(unitA.getProjectId(), true);
            if (projectA == null) {
                String server = unitA.getServer() != null ? unitA.getServer() : "";
                String msg = String.format(this.getString("ProjectSynchronizationService.error.project.not.found"), unitA.getProjectId(), server);
                throw new ServiceFailureException(msg);
            }
            CommonClientProject projectB = serviceB.openProject(unitB.getProjectId(), true);
            if (projectB == null) {
                String server = unitB.getServer() != null ? unitB.getServer() : "";
                String msg = String.format(this.getString("ProjectSynchronizationService.error.project.not.found"), unitB.getProjectId(), server);
                throw new ServiceFailureException(msg);
            }
            try {
                this.copyFiles(serviceA, projectA, serviceB, projectB, unitA.getFiles(), resultsA, monitor);
                this.copyFiles(serviceB, projectB, serviceA, projectA, unitB.getFiles(), resultsB, monitor);
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            serviceA.closeProject(projectA.getId(), true);
            serviceB.closeProject(projectB.getId(), true);
        }
        catch (RemoteException e) {
            throw new ServiceFailureException(this.getString("ProjectSynchronizationService.error.rmi"), (Throwable)e);
        }
    }

    public ProjectSynchronizationResult synchronizeProjects(ProjectSynchronizationData data, ProjectSynchronizationMonitor monitor) {
        String errorMsg = null;
        ProjectSynchronizationResult result = null;
        Vector<String> resultsA = new Vector<String>();
        Vector<String> resultsB = new Vector<String>();
        Monitor localMonitor = new Monitor(monitor);
        try {
            ProjectSynchronizationUnit unitA = data.getUnitA();
            LoginInfo loginInfoA = this.remoteLogin(unitA.getServer(), unitA.getLogin(), unitA.getPassword());
            ProjectSynchronizationUnit unitB = data.getUnitB();
            LoginInfo loginInfoB = this.remoteLogin(unitB.getServer(), unitB.getLogin(), unitB.getPassword());
            this.transferFiles(loginInfoA.projectService, loginInfoB.projectService, unitA, unitB, resultsA, resultsB, localMonitor);
            this.remoteLogout(loginInfoA);
            this.remoteLogout(loginInfoB);
        }
        catch (ServiceFailureException e) {
            errorMsg = e.getMessage();
            result = new ProjectSynchronizationResult(errorMsg, e.getCause(), resultsA, resultsB);
        }
        localMonitor.finalResult(errorMsg);
        if (result == null) {
            result = new ProjectSynchronizationResult(resultsA, resultsB);
        }
        return result;
    }

    private boolean acceptFileFilters(ClientProjectFile node) {
        List<String> filtersList = this.getStringListProperty("filesFilterPatternsToHide");
        if (filtersList == null || filtersList.isEmpty()) {
            return false;
        }
        for (String filterName : filtersList) {
            if (filterName.isEmpty()) {
                return true;
            }
            ProjectFileNameFilter filter = new ProjectFileNameFilter(filterName);
            if (!filter.accept(node)) continue;
            return true;
        }
        return false;
    }

    private static class CancelledException
    extends RuntimeException {
        private CancelledException() {
        }
    }

    private static class LoginInfo {
        String serverName;
        Session session;
        ServerEntryPoint server;
        ProjectServiceInterface projectService;

        private LoginInfo() {
        }
    }

    private class Monitor
    implements ProjectSynchronizationMonitor {
        private final ProjectSynchronizationMonitor monitor;

        Monitor(ProjectSynchronizationMonitor monitor) {
            this.monitor = monitor;
        }

        public void partialResult(String[] file, String result) {
            if (this.monitor == null) {
                return;
            }
            try {
                this.monitor.partialResult(file, result);
            }
            catch (RemoteException e) {
                Server.logWarningMessage("Ignorando falha em monitor.partialResult: " + e);
            }
        }

        public void finalResult(String result) {
            if (this.monitor == null) {
                return;
            }
            try {
                this.monitor.finalResult(result);
            }
            catch (RemoteException e) {
                Server.logWarningMessage("Ignorando falha em monitor.finalResult: " + e);
            }
        }

        public boolean isCancelled() {
            if (this.monitor == null) {
                return false;
            }
            try {
                return this.monitor.isCancelled();
            }
            catch (RemoteException e) {
                Server.logWarningMessage("Ignorando falha em monitor.isCancelled: " + e);
                return false;
            }
        }

        public void initTransfer(String file) throws RemoteException {
            this.monitor.initTransfer(file);
        }
    }
}

