/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SchedulerPolicyRestriction;
import java.util.HashMap;

public class QuarantaineRestriction
implements SchedulerPolicyRestriction {
    private final HashMap<String, Long> recentUsedServers = new HashMap();
    private long sgaQuarantine;

    public QuarantaineRestriction(long sgaQuarantine) {
        this.sgaQuarantine = sgaQuarantine;
    }

    @Override
    public boolean isSGAAvailable(SGASet server) {
        if (!this.recentUsedServers.containsKey(server.getName())) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (this.sgaQuarantine > 0L && now - this.recentUsedServers.get(server.getName()) <= this.sgaQuarantine) {
            return false;
        }
        this.recentUsedServers.remove(server.getName());
        return true;
    }

    public void addToQuarantaine(SGASet server) {
        this.recentUsedServers.put(server.getName(), System.currentTimeMillis());
    }
}

