/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.classadpolicies;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdManager;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdMatchInfo;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdPolicyCommons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassAdPolicy2
implements SchedulerPolicyInterface {
    @Override
    public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> servers) {
        ClassAdManager manager = new ClassAdManager();
        HashMap<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
        ArrayList<ClassAdMatchInfo> matches = new ArrayList<ClassAdMatchInfo>();
        for (CommandInfo cmd : commands) {
            matches.addAll(ClassAdPolicyCommons.getMatchedAds(cmd, servers, manager));
        }
        while (!matches.isEmpty()) {
            Collections.sort(matches, Collections.reverseOrder());
            ClassAdMatchInfo winner = (ClassAdMatchInfo)matches.get(0);
            CommandInfo commandWinner = winner.getCommand();
            SGASet choosedServer = winner.getSGA();
            allocation.put(commandWinner, choosedServer);
            this.removeDuplicates(commandWinner, choosedServer, matches);
        }
        return allocation;
    }

    private void removeDuplicates(CommandInfo commandWinner, SGASet choosedServer, ArrayList<ClassAdMatchInfo> matches) {
        ArrayList<ClassAdMatchInfo> toBeRemoved = new ArrayList<ClassAdMatchInfo>();
        for (ClassAdMatchInfo cainfo : matches) {
            if (cainfo.getSGA() != choosedServer && cainfo.getCommand() != commandWinner) continue;
            toBeRemoved.add(cainfo);
        }
        for (ClassAdMatchInfo cainfo : toBeRemoved) {
            matches.remove(cainfo);
        }
    }
}

