/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice.ssl;

import csbase.server.Server;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.CurrentHelper;
import org.omg.PortableInterceptor.InvalidSlot;

public class SSLContext
extends LocalObject {
    public static final String INITIAL_REFERENCE_ID = SSLContext.class.getSimpleName();
    private ORB orb;
    private int slotId;

    SSLContext(int slotId) {
        this.slotId = slotId;
    }

    public static SSLContext getSSLContext(ORB orb) {
        Object obj = null;
        try {
            obj = orb.resolve_initial_references(INITIAL_REFERENCE_ID);
        }
        catch (InvalidName e) {
            e.printStackTrace();
        }
        if (obj == null) {
            Server.logSevereMessage("O contexto SSL n\u00e3o foi encontrado.");
        }
        return (SSLContext)obj;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public ORB getORB() {
        return this.orb;
    }

    private Current getPICurrent(ORB orb) {
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("PICurrent");
        }
        catch (InvalidName e) {
            Server.logSevereMessage("Erro ao obt\u00e9r o PICurrent", e);
        }
        return CurrentHelper.narrow((Object)obj);
    }

    public String getContextInformation() {
        Current current = this.getPICurrent(this.orb);
        try {
            Any any = current.get_slot(this.slotId);
            if (any.type().kind().value() == 0) {
                return null;
            }
            return any.extract_string();
        }
        catch (InvalidSlot e) {
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel recuperar informa\u00e7\u00e3o no slotId", e);
            return null;
        }
    }

    public void setContextInformation(String info) {
        Current current = this.getPICurrent(this.orb);
        Any any = this.orb.create_any();
        if (info != null) {
            any.insert_string(info);
        }
        try {
            current.set_slot(this.slotId, any);
        }
        catch (InvalidSlot e) {
            Server.logSevereMessage("N\u00e3o foi poss\u00edvel salvar informa\u00e7\u00e3o no slotId", e);
        }
    }

    public void clearContextInformation() {
        this.setContextInformation(null);
    }
}

