package csbase.server.services.ftcservice;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;

import csbase.server.Server;

public class FTCLogHandler extends FileHandler {

  /*
   * O FTCLogHandler no  carregado se o diretrio definido em
   * csbase.server.services.ftcservice.FTCLogHandler.pattern no existir. O erro
   * somente aparece na primeira vez que algum logger  usado. Para contornar
   * este problema, estamos criando o diretrio a partir do valor definido na
   * propriedade.
   * 
   * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6244047
   */
  static {
    try {
      String filePattern =
        java.util.logging.LogManager.getLogManager().getProperty(
          "csbase.server.services.ftcservice.FTCLogHandler.pattern");
      if (filePattern != null) {
        File fileParent = new File(filePattern).getParentFile();
        if (fileParent != null) {
          Server.checkDirectory(Server.generateDirectoryFileName(fileParent
            .getAbsolutePath()));
        }
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  public FTCLogHandler() throws IOException, SecurityException {
    super();
  }

}
