package csbase.server.services.opendreamsservice.opendreams.rest;

import io.swagger.jaxrs.config.BeanConfig;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.jersey.servlet.ServletContainer;

import java.io.IOException;

/**
 * Main class.
 */
public class Main {

	/**
	 * Main method.
	 *
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {
		try {
			// Workaround for resources from JAR files
			Resource.setDefaultUseCaches(false);
			buildSwagger();

			final HandlerList handlers = new HandlerList();
			handlers.addHandler(buildSwaggerUI());
			handlers.addHandler(buildContext());
			Server server = new Server(OpenDreams.SERVER_PORT);
			server.setHandler(handlers);
			server.start();
			server.join();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static void buildSwagger() {
		BeanConfig beanConfig = new BeanConfig();
		beanConfig.setVersion("1.0.0");
		beanConfig.setResourcePackage("csbase.server.services.opendreamsservice.opendreams.rest.resources");
		beanConfig.setScan(true);
		beanConfig.setBasePath("/" + OpenDreams.API_NAME);
		beanConfig.setDescription("OpenDreams API with Jersey 2 and Swagger in an embedded Jetty instance");
		beanConfig.setTitle("OpenDreams API");
	}

	private static ContextHandler buildContext() {
		ServletContainer servletContainer = new ServletContainer(new OpenDreams());
		ServletHolder entityBrowser = new ServletHolder(servletContainer);
		ServletContextHandler entityBrowserContext = new ServletContextHandler(ServletContextHandler.SESSIONS);
		entityBrowserContext.setContextPath("/" + OpenDreams.API_NAME);
		entityBrowserContext.addServlet(entityBrowser, "/*");
		return entityBrowserContext;
	}

	private static ContextHandler buildSwaggerUI() throws Exception {
		final ResourceHandler swaggerUIResourceHandler = new ResourceHandler();
		swaggerUIResourceHandler
				.setResourceBase(Main.class.getClassLoader().getResource("swagger-ui").toURI().toString());
		final ContextHandler swaggerUIContext = new ContextHandler();
		swaggerUIContext.setContextPath("/docs/");
		swaggerUIContext.setHandler(swaggerUIResourceHandler);
		return swaggerUIContext;
	}
}
