package csbase.server.services.schedulerservice.classadpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;

public class ClassAdPolicy3 implements SchedulerPolicyInterface {
	/*
	 * Terceira implementao de chooseServer: escolhe o melhor SGA para cada
	 * comando, na ordem em que estes aparecerem na ordenao dos matches. Leva
	 * em considerao alocaes anteriores.
	 */
	public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands,
			List<SGASet> servers) {

		HashMap<String, SGASet> originalServers = new HashMap<String, SGASet>();
		ClassAdManager manager = new ClassAdManager();
		List<CommandInfo> commandsToResolve = new ArrayList<CommandInfo>(
				commands);
		List<SGASet> simulatedServers = new ArrayList<SGASet>(servers);
		Map<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
		ArrayList<ClassAdMatchInfo> matches = new ArrayList<ClassAdMatchInfo>();

		for (SGASet sga : servers) {
			originalServers.put(sga.getName(), sga);
		}

		while (!commandsToResolve.isEmpty()) {
			for (CommandInfo cmd : commandsToResolve) {
				matches.addAll(ClassAdPolicyCommons.getMatchedAds(cmd,
						simulatedServers, manager));
			}

			if (matches.isEmpty())
				break;

			Collections.sort(matches);
			ClassAdMatchInfo winnerAd = matches.get(0);
			SGASet sga = winnerAd.getSGA();
			CommandInfo cmd = winnerAd.getCommand();
			allocation.put(cmd, originalServers.get(sga.getName()));

			commandsToResolve.remove(cmd);
			SGASet updatedSGA = ClassAdPolicyCommons
					.simulateResourceConsumption(cmd, sga);
			simulatedServers.remove(sga);
			simulatedServers.add(updatedSGA);
			manager.alterSGAAd(updatedSGA);
			matches.clear();
		}

		return allocation;
	}

}
