package csbase.server.services.schedulerservice.classadpolicies;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.CommandGreedinessComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;

public class ClassAdPolicy4 implements SchedulerPolicyInterface {

	/*
	 * Quarta implementao de chooseServer: escolhe o melhor SGA (Segundo o
	 * rank) para casa comando, na ordem em que aparecem na lista ordenada
	 * segundo o CommandGreedinessComparator
	 */

	public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands,
			List<SGASet> servers) {
		ClassAdManager manager = new ClassAdManager();
		Map<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();

		Collections.sort(commands,
				Collections.reverseOrder(new CommandGreedinessComparator()));

		for (CommandInfo cmd : commands) {
			List<SGASet> sgas;

			sgas = ClassAdPolicyCommons.getSGAsSortedByDefaultClassAdRank(cmd,
					servers, manager);

			if (sgas.size() != 0)
				allocation.put(cmd, sgas.get(0));
		}
		return allocation;
	}
}
