package csbase.server.services.schedulerservice.heuristic;

import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.CommandGreedinessComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdResourceController;

public class HeuristicPolicy1 implements SchedulerPolicyInterface {
	ClassAdResourceController rController;
	AllocationComparatorByPriority allocComp = new AllocationComparatorByPriority();
	CommandGreedinessComparator cmdComp = new CommandGreedinessComparator();

	@Override
	public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands,
			List<SGASet> servers) {
		this.rController = new ClassAdResourceController();
		FeasibleWithTreeHeuristicApplyer heuristic = new FeasibleWithTreeHeuristicApplyer(cmdComp, allocComp,
				commands, servers, rController);
		Allocation allocation = heuristic.getAllocation();
		return allocation.isFeasible() ? allocation.getFeasibleAllocationMap()
				: allocation.getPartialAllocationMap();
	}

}
