package csbase.server.services.schedulerservice.sgafilters;

import java.util.LinkedList;
import java.util.List;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;

public class SGASimpleFilter {
	public static List<SGASet> filter(CommandInfo cmd, List<SGASet> servers) {
		SGACriteria availabilityCriteria;
		SGACriteria userPermission;

		// Filtro pela disponibilidade -> obrigatrio
		availabilityCriteria = new SGACriteriaByAvailability();

		// Filtro por permisso do usurio -> obrigatrio
		userPermission = new SGACriteriaByUserPermission(cmd.getUserId());
		
		List<SGACriteria> criteriasToMeet = new LinkedList<SGACriteria>();
		criteriasToMeet.add(availabilityCriteria);
		criteriasToMeet.add(userPermission);
		
		SGACriteria finalCriteria = new SGACriteriaAnd(criteriasToMeet);
		
		return new SGAFilter(finalCriteria).filter(servers);
	}
}
