/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.rest;

import csbase.server.services.opendreamsservice.opendreams.rest.OpenDreams;
import io.swagger.jaxrs.config.BeanConfig;
import java.io.IOException;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class Main {
    public static void main(String[] args) throws IOException {
        try {
            Resource.setDefaultUseCaches((boolean)false);
            Main.buildSwagger();
            HandlerList handlers = new HandlerList();
            handlers.addHandler((Handler)Main.buildSwaggerUI());
            handlers.addHandler((Handler)Main.buildContext());
            Server server = new Server(8080);
            server.setHandler((Handler)handlers);
            server.start();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildSwagger() {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setVersion("1.0.0");
        beanConfig.setResourcePackage("csbase.server.services.opendreamsservice.opendreams.rest.resources");
        beanConfig.setScan(true);
        beanConfig.setBasePath("/drmaa2");
        beanConfig.setDescription("OpenDreams API with Jersey 2 and Swagger in an embedded Jetty instance");
        beanConfig.setTitle("OpenDreams API");
    }

    private static ContextHandler buildContext() {
        ServletContainer servletContainer = new ServletContainer((ResourceConfig)new OpenDreams());
        ServletHolder entityBrowser = new ServletHolder((Servlet)servletContainer);
        ServletContextHandler entityBrowserContext = new ServletContextHandler(1);
        entityBrowserContext.setContextPath("/drmaa2");
        entityBrowserContext.addServlet(entityBrowser, "/*");
        return entityBrowserContext;
    }

    private static ContextHandler buildSwaggerUI() throws Exception {
        ResourceHandler swaggerUIResourceHandler = new ResourceHandler();
        swaggerUIResourceHandler.setResourceBase(Main.class.getClassLoader().getResource("swagger-ui").toURI().toString());
        ContextHandler swaggerUIContext = new ContextHandler();
        swaggerUIContext.setContextPath("/docs/");
        swaggerUIContext.setHandler((Handler)swaggerUIResourceHandler);
        return swaggerUIContext;
    }
}

