/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.rest;

import csbase.server.services.administrationservice.AdministrationService;
import javax.inject.Singleton;
import org.glassfish.jersey.server.ResourceConfig;
import tecgraf.openbus.DRMAA.v2_0.DeniedByDrmsException;

@Singleton
public class OpenDreams
extends ResourceConfig {
    public static final String API_NAME = "drmaa2";
    public static final int SERVER_PORT = 8080;
    public static final String BASE_URI = "http://localhost:8080/drmaa2/";

    public OpenDreams() {
        this.packages(new String[]{"csbase.server.services.opendreamsservice.opendreams.rest.resources", "io.swagger.jaxrs.listing"});
    }

    public static void checkUser(String userId) throws DeniedByDrmsException {
        if (AdministrationService.getInstance().getUser(userId) == null) {
            throw new DeniedByDrmsException("O usu\u00c3\u00a1rio " + userId + " n\u00c3\u00a3o existe.");
        }
    }

    public static class DRMAA2 {

        public static enum DrmaaCapability {
            ADVANCE_RESERVATION,
            RESERVE_SLOTS,
            CALLBACK,
            BULK_JOBS_MAXPARALLEL,
            JT_EMAIL,
            JT_STAGING,
            JT_DEADLINE,
            JT_MAXSLOTS,
            JT_ACCOUNTINGID,
            RT_STARTNOW,
            RT_DURATION,
            RT_MACHINEOS,
            RT_MACHINEARCH;

        }

        public static enum DrmaaEvent {
            NEW_STATE,
            MIGRATED,
            ATTRIBUTE_CHANGE;

        }

        public static enum ResourceLimitType {
            CORE_FILE_SIZE,
            CPU_TIME,
            DATA_SIZE,
            FILE_SIZE,
            OPEN_FILES,
            STACK_SIZE,
            VIRTUAL_MEMORY,
            WALLCLOCK_TIME;

        }

        public static enum CpuArchitecture {
            ALPHA,
            ARM,
            ARM64,
            CELL,
            PARISC,
            PARISC64,
            X86,
            X64,
            IA64,
            MIPS,
            MIPS64,
            PPC,
            PPC64,
            SPARC,
            SPARC64,
            OTHER_CPU;

        }

        public static enum OperatingSystem {
            AIX,
            BSD,
            LINUX,
            HPUX,
            IRIX,
            MACOS,
            SUNOS,
            TRU64,
            UNIXWARE,
            WIN,
            WINNT,
            OTHER_OS;

        }

        public static enum JobState {
            UNDETERMINED,
            QUEUED,
            QUEUED_HELD,
            RUNNING,
            SUSPENDED,
            REQUEUED,
            REQUEUED_HELD,
            DONE,
            FAILED;

        }
    }
}

