/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_8;

import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandNotification;
import csbase.logic.CommandSuccessNotification;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.FailureFinalizationType;
import csbase.server.Server;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import tecgraf.openbus.DRMAA.v1_8.ExitTimeoutException;
import tecgraf.openbus.DRMAA.v1_8.InvalidJobException;
import tecgraf.openbus.DRMAA.v1_8.JobInfo;
import tecgraf.openbus.opendreams.v1_8.FinalizationType;
import tecgraf.openbus.opendreams.v1_8.OpenDreamsJobInfo;
import tecgraf.openbus.opendreams.v1_8.OpenDreamsJobInfoImpl;
import tecgraf.opendreams.commontypes.v1_0.Property;

public class JobInfoQueue {
    public static final int NO_EXIT_CODE = 256;
    public static final long WAITING_TIMEOUT = 100L;
    private Map<String, OpenDreamsJobInfo> jobsSubmited = new Hashtable<String, OpenDreamsJobInfo>();

    public synchronized void jobSubmited(String jobId) {
        OpenDreamsJobInfo jobInfo = this.jobsSubmited.get(jobId);
        if (jobInfo == null) {
            jobInfo = new OpenDreamsJobInfoImpl();
            jobInfo.jobId = jobId;
            this.jobsSubmited.put(jobId, jobInfo);
        }
    }

    public synchronized void jobExit(CommandNotification cmdEvent) {
        ExtendedCommandFinalizationInfo finalizationInfo;
        String jobId = cmdEvent.getCommandId().toString();
        OpenDreamsJobInfo jobInfo = this.jobsSubmited.get(jobId);
        if (jobInfo == null) {
            jobInfo = new OpenDreamsJobInfoImpl();
            jobInfo.jobId = jobId;
            this.jobsSubmited.put(jobId, jobInfo);
        }
        ArrayList<Property> resourceUsage = new ArrayList<Property>();
        if (cmdEvent.getFinalizationInfo().getFinalizationType() == CommandFinalizationType.SUCCESS) {
            Map execData;
            CommandSuccessNotification endNotification = (CommandSuccessNotification)cmdEvent;
            if (endNotification.getCPUTime() != null) {
                resourceUsage.add(new Property("cpu_time", endNotification.getCPUTime().toString()));
            }
            if (endNotification.getElapsedTime() != null) {
                resourceUsage.add(new Property("elapsed_time", endNotification.getElapsedTime().toString()));
            }
            if (endNotification.getUserTime() != null) {
                resourceUsage.add(new Property("user_time", endNotification.getUserTime().toString()));
            }
            if ((execData = endNotification.getExecutionData()) != null) {
                jobInfo.executionData = new Property[execData.size()];
                Iterator iterator = execData.entrySet().iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    Map.Entry data = iterator.next();
                    jobInfo.executionData[index] = new Property((String)data.getKey(), (String)data.getValue());
                    ++index;
                }
            }
        }
        if (resourceUsage.size() > 0) {
            jobInfo.resourceUsage = resourceUsage.toArray(new Property[resourceUsage.size()]);
        }
        if (cmdEvent.getFinalizationInfo().getInfoType() == CommandFinalizationInfo.FinalizationInfoType.EXTENDED) {
            finalizationInfo = (ExtendedCommandFinalizationInfo)cmdEvent.getFinalizationInfo();
            jobInfo.guiltyNodeId = String.valueOf(finalizationInfo.getGuiltyNodeId());
        }
        jobInfo.hasExited = true;
        finalizationInfo = cmdEvent.getFinalizationInfo();
        if (finalizationInfo == null) {
            Server.logSevereMessage("A informa\u00e7\u00e3o de finalizacao do comando " + jobId + " n\u00e3o existe (null)");
            jobInfo.exitStatus = 256;
        } else {
            Integer exitCode = finalizationInfo.getExitCode();
            Server.logInfoMessage("A informa\u00e7\u00e3o de finalizacao do comando " + jobId + " possui exitCode=" + exitCode);
            jobInfo.exitStatus = exitCode == null ? 256 : exitCode;
            jobInfo.finalizationType = this.getFinalizationType(finalizationInfo.getFinalizationType(), finalizationInfo.getFailureCause());
            jobInfo.description = finalizationInfo.getFailureCause() == null ? finalizationInfo.getFinalizationType().getDescription() : finalizationInfo.getFailureCause().getDescription();
        }
        jobInfo.wasAborted = cmdEvent.getFinalizationInfo().getFinalizationType().equals((Object)FinalizationType.KILLED);
        jobInfo.hasSignaled = false;
        jobInfo.terminatingSignal = "";
        jobInfo.hasCoreDump = false;
        this.notifyAll();
    }

    private FinalizationType getFinalizationType(CommandFinalizationType type, FailureFinalizationType cause) {
        switch (type) {
            case END: {
                return FinalizationType.EXIT_CODE_IGNORED;
            }
            case SUCCESS: {
                return FinalizationType.EXIT_CODE_SUCCESS;
            }
            case EXECUTION_ERROR: {
                return FinalizationType.EXIT_CODE_ERROR;
            }
            case NO_EXIT_CODE: {
                return FinalizationType.EXIT_CODE_FAILED;
            }
            case FAILED: {
                switch (cause) {
                    case UNKNOWN: {
                        return FinalizationType.UNKNOWN;
                    }
                    case COMMAND_IDENTIFIER_NOT_FOUND: {
                        return FinalizationType.COMMAND_IDENTIFIER_NOT_FOUND;
                    }
                    case SGA_EXECUTION_ERROR: {
                        return FinalizationType.SGA_EXECUTION_ERROR;
                    }
                    case CSFS_SERVICE_UNAVAILABLE: {
                        return FinalizationType.CSFS_SERVICE_UNAVAILABLE;
                    }
                    case FAILED_SETUP_EXECUTION_ENVIRONMENT: {
                        return FinalizationType.FAILED_SETUP_EXECUTION_ENVIRONMENT;
                    }
                    case NO_SGA_AVAILABLE_TO_ROOT_COMMAND: {
                        return FinalizationType.NO_SGA_AVAILABLE_TO_ROOT_COMMAND;
                    }
                    case SGA_IS_NOT_AVAILABLE: {
                        return FinalizationType.SGA_IS_NOT_AVAILABLE;
                    }
                    case PROJECT_NOT_FOUND: {
                        return FinalizationType.PROJECT_NOT_FOUND;
                    }
                    case USER_WITHOUT_PERMISSION_FOR_EXECUTION: {
                        return FinalizationType.USER_WITHOUT_PERMISSION_FOR_EXECUTION;
                    }
                }
            }
            case KILLED: {
                return FinalizationType.KILLED;
            }
            case LOST: {
                return FinalizationType.LOST;
            }
        }
        return FinalizationType.UNDEFINED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo waitFor(String jobId, long timeout) throws InvalidJobException, ExitTimeoutException {
        boolean waitForever;
        JobInfoQueue jobInfoQueue = this;
        synchronized (jobInfoQueue) {
            JobInfo info = (JobInfo)this.jobsSubmited.get(jobId);
            if (info == null) {
                throw new InvalidJobException("N\u00e3o foi encontrado um job com o nome especificado: " + jobId);
            }
            if (timeout == 0L) {
                this.jobsSubmited.remove(jobId);
                if (!info.hasExited) {
                    throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou: " + jobId);
                }
                return info;
            }
        }
        long start = System.currentTimeMillis();
        long limit = timeout * 1000L;
        boolean bl = waitForever = timeout == -1L;
        while (waitForever || System.currentTimeMillis() - start < limit) {
            try {
                JobInfoQueue jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    this.wait(100L);
                }
                jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    JobInfo info = (JobInfo)this.jobsSubmited.get(jobId);
                    if (info == null) {
                        throw new InvalidJobException("Outra requisi\u00e7\u00e3o j\u00e1 recebeu a informa\u00e7\u00e3o de t\u00e9rmino dessemesmo job: " + jobId);
                    }
                    if (info.hasExited) {
                        this.jobsSubmited.remove(jobId);
                        return info;
                    }
                }
            }
            catch (InterruptedException e) {
            }
        }
        throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou: " + jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo waitForAnyJob(long timeout) throws ExitTimeoutException, InvalidJobException {
        boolean waitForever;
        Set<String> jobsAvailable = this.jobsSubmited.keySet();
        JobInfoQueue jobInfoQueue = this;
        synchronized (jobInfoQueue) {
            if (this.jobsSubmited.size() == 0) {
                throw new InvalidJobException("N\u00e3o h\u00e1 mais jobs submetidos na sess\u00e3o que ainda n\u00e3o tenham terminado sua execu\u00e7\u00e3o");
            }
            if (timeout == 0L) {
                for (String jobId : jobsAvailable) {
                    JobInfo info = (JobInfo)this.jobsSubmited.get(jobId);
                    if (!info.hasExited) continue;
                    this.jobsSubmited.remove(jobId);
                    return info;
                }
                throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou");
            }
        }
        long start = System.currentTimeMillis();
        long limit = timeout * 1000L;
        boolean bl = waitForever = timeout == -1L;
        while (waitForever || System.currentTimeMillis() - start < limit) {
            try {
                JobInfoQueue jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    this.wait(100L);
                }
                jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    JobInfo info = null;
                    for (String jobId : jobsAvailable) {
                        info = (JobInfo)this.jobsSubmited.get(jobId);
                        if (!info.hasExited) continue;
                        this.jobsSubmited.remove(jobId);
                        return info;
                    }
                    if (info == null) {
                        throw new InvalidJobException("N\u00e3o h\u00e1 mais jobs submetidos na sess\u00e3o que ainda n\u00e3o tenham terminado sua execu\u00e7\u00e3o");
                    }
                }
            }
            catch (InterruptedException e) {
            }
        }
        throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getJobInfo(String jobId) throws InvalidJobException {
        JobInfoQueue jobInfoQueue = this;
        synchronized (jobInfoQueue) {
            JobInfo info = (JobInfo)this.jobsSubmited.get(jobId);
            if (info == null) {
                throw new InvalidJobException("N\u00e3o foi encontrado um job com o nome especificado: " + jobId);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(String[] jobIdList, long timeout, boolean dispose) throws InvalidJobException, ExitTimeoutException {
        boolean waitForever;
        if (jobIdList.length == 0) {
            return;
        }
        JobInfoQueue jobInfoQueue = this;
        synchronized (jobInfoQueue) {
            if (timeout == 0L) {
                if (dispose) {
                    for (String jobId : jobIdList) {
                        this.jobsSubmited.remove(jobId);
                    }
                }
                return;
            }
        }
        long start = System.currentTimeMillis();
        long limit = timeout * 1000L;
        boolean bl = waitForever = timeout == -1L;
        while (waitForever || System.currentTimeMillis() - start < limit) {
            try {
                JobInfoQueue jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    this.wait(100L);
                }
                jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    JobInfo info;
                    boolean allHasExited = true;
                    for (String jobId : jobIdList) {
                        info = (JobInfo)this.jobsSubmited.get(jobId);
                        if (info == null) {
                            throw new InvalidJobException("Outra requisi\u00e7\u00e3o j\u00e1 recebeu a informa\u00e7\u00e3o de t\u00e9rmino dessemesmo job: " + jobId);
                        }
                        allHasExited = allHasExited && info.hasExited;
                    }
                    if (allHasExited) {
                        for (String jobId : jobIdList) {
                            info = (JobInfo)this.jobsSubmited.get(jobId);
                            if (info == null) {
                                throw new InvalidJobException("Outra requisi\u00e7\u00e3o j\u00e1 recebeu a informa\u00e7\u00e3o de t\u00e9rmino dessemesmo job: " + jobId);
                            }
                            if (!dispose) continue;
                            this.jobsSubmited.remove(jobId);
                        }
                        return;
                    }
                }
            }
            catch (InterruptedException e) {
            }
        }
        throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou: " + jobIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllJobs(long timeout, boolean dispose) throws ExitTimeoutException {
        boolean waitForever;
        String[] jobIdList = this.getAllJobs();
        if (jobIdList.length == 0) {
            return;
        }
        JobInfoQueue jobInfoQueue = this;
        synchronized (jobInfoQueue) {
            if (timeout == 0L) {
                if (dispose) {
                    for (String jobId : jobIdList) {
                        this.jobsSubmited.remove(jobId);
                    }
                }
                return;
            }
        }
        long start = System.currentTimeMillis();
        long limit = timeout * 1000L;
        boolean bl = waitForever = timeout == -1L;
        while (waitForever || System.currentTimeMillis() - start < limit) {
            try {
                JobInfoQueue jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    this.wait(100L);
                }
                jobInfoQueue2 = this;
                synchronized (jobInfoQueue2) {
                    JobInfo info;
                    boolean allHasExited = true;
                    for (String jobId : jobIdList) {
                        info = (JobInfo)this.jobsSubmited.get(jobId);
                        if (info == null) continue;
                        allHasExited = allHasExited && info.hasExited;
                    }
                    if (allHasExited) {
                        for (String jobId : jobIdList) {
                            info = (JobInfo)this.jobsSubmited.get(jobId);
                            if (info == null || !dispose) continue;
                            this.jobsSubmited.remove(jobId);
                        }
                        return;
                    }
                }
            }
            catch (InterruptedException e) {
            }
        }
        throw new ExitTimeoutException("O timeout esgotou e o job n\u00e3o terminou: " + jobIdList);
    }

    public String[] getAllJobs() {
        String[] jobs = new String[this.jobsSubmited.size()];
        return this.jobsSubmited.keySet().toArray(jobs);
    }
}

