/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.BalancedCommandDistribution;
import csbase.server.services.schedulerservice.SGASetCPUCapacityComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.sgafilters.SGAFilterByCommandRequirements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CPUCapacityPolicy
implements SchedulerPolicyInterface {
    @Override
    public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> servers) {
        BalancedCommandDistribution bdc = new BalancedCommandDistribution(servers);
        HashMap<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
        for (CommandInfo cmd : commands) {
            List<SGASet> sgas;
            List<SGASet> filteresSGAs = SGAFilterByCommandRequirements.filter(cmd, servers);
            if (filteresSGAs == null || (sgas = this.getSortedSGAByCPUCapacity(filteresSGAs)).size() == 0) continue;
            SGASet choosedServer = bdc.chooseLightest(sgas);
            allocation.put(cmd, choosedServer);
        }
        return allocation;
    }

    private List<SGASet> getSortedSGAByCPUCapacity(List<SGASet> servers) {
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        sgasSets.addAll(servers);
        Collections.sort(sgasSets, new SGASetCPUCapacityComparator());
        return sgasSets;
    }
}

