/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.GreedCommandComparator;
import csbase.server.services.schedulerservice.NewSchedulerPolicyInterface;
import csbase.server.services.schedulerservice.SGASetCPUComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyRestriction;
import csbase.server.services.schedulerservice.sgafilters.SGAFilterByCommandRequirements;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NewPercCPUPolicy
implements NewSchedulerPolicyInterface {
    List<CommandInfo> commands = new ArrayList<CommandInfo>();
    List<SGASet> servers = new ArrayList<SGASet>();
    List<SchedulerPolicyRestriction> restrictions = new ArrayList<SchedulerPolicyRestriction>();

    @Override
    public void init(List<CommandInfo> cmds, List<SGASet> sgas) {
        this.commands.clear();
        this.commands.addAll(cmds);
        Collections.sort(this.commands, Collections.reverseOrder(new GreedCommandComparator()));
        this.servers.clear();
        this.servers.addAll(sgas);
    }

    @Override
    public Map.Entry<CommandInfo, List<SGASet>> getAllocation() {
        if (this.commands.isEmpty() || this.servers.isEmpty()) {
            return null;
        }
        for (CommandInfo currCmd : this.commands) {
            List<SGASet> orderedServers;
            List<SGASet> availableServers;
            List<SGASet> filteresSGAs = SGAFilterByCommandRequirements.filter(currCmd, this.servers);
            if (filteresSGAs == null || filteresSGAs.isEmpty() || (availableServers = this.filterUnavailableServers(filteresSGAs)) == null || availableServers.isEmpty() || (orderedServers = this.getSortedSGAByCPU(availableServers)).size() == 0) continue;
            return new AbstractMap.SimpleEntry<CommandInfo, List<SGASet>>(currCmd, orderedServers);
        }
        return null;
    }

    @Override
    public void addRestriction(SchedulerPolicyRestriction restriction) {
        this.restrictions.add(restriction);
    }

    @Override
    public void removeCommand(CommandInfo cmd) {
        this.commands.remove(cmd);
    }

    @Override
    public void notifySucessfulAllocation(CommandInfo cmd, SGASet server) {
        this.commands.remove(cmd);
        SGASet choosedServerCopy = new SGASet(this.updateSGAInfo(cmd, server.getMainInfo()), server.getName(), server.getEnabled(), server.getAlive(), server.hasDiskAccess(), server.isBackoffExpired(), server.getJobsInfo(), server.isCSFSEnabled(), null, System.currentTimeMillis());
        this.servers.remove(server);
        this.servers.add(choosedServerCopy);
    }

    private SGAInfo[] updateSGAInfo(CommandInfo cmd, SGAInfo info) {
        int ramInfo = 0;
        try {
            double sgaFreeRam = info.getRAMFreeMemoryMb();
            double commandUseRam = cmd.getConfigurator().getMemoryAmount();
            ramInfo = (int)(sgaFreeRam - commandUseRam);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        SGAInfo newInfo = new SGAInfo(info.getHostName(), info.getPlatformId(), info.getNumProcessors(), info.getRAMMemoryInfoMb(), 0, info.getClockSpeedMHz(), info.getFileSeparator(), info.getProjectRootDirectory(), info.getAlgorithmRootDirectory(), info.getSandboxRootDirectory(), null);
        newInfo.setAlive(true);
        newInfo.setRAMFreeMemory((double)ramInfo);
        Set requirements = info.getRequirements();
        for (String req : requirements) {
            newInfo.addRequirement(req);
        }
        SGAInfo[] infos = new SGAInfo[]{newInfo};
        return infos;
    }

    private List<SGASet> getSortedSGAByCPU(List<SGASet> servers) {
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        sgasSets.addAll(servers);
        Collections.sort(sgasSets, new SGASetCPUComparator());
        return sgasSets;
    }

    private List<SGASet> filterUnavailableServers(List<SGASet> servers) {
        ArrayList<SGASet> filteredServers = new ArrayList<SGASet>();
        for (SGASet sga : servers) {
            if (!this.checkServerAvailability(sga)) continue;
            filteredServers.add(sga);
        }
        return filteredServers;
    }

    private boolean checkServerAvailability(SGASet server) {
        for (SchedulerPolicyRestriction restriction : this.restrictions) {
            if (restriction.isSGAAvailable(server)) continue;
            return false;
        }
        return true;
    }
}

