/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.BalancedCommandDistribution;
import csbase.server.services.schedulerservice.CommandGreedinessComparator;
import csbase.server.services.schedulerservice.SGASetCPUComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.sgafilters.SGAFilterByCommandRequirements;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PercCPUPolicy
implements SchedulerPolicyInterface {
    @Override
    public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> servers) {
        HashMap<String, SGASet> originalServers = new HashMap<String, SGASet>();
        ArrayList<SGASet> updatedServers = new ArrayList<SGASet>(servers);
        BalancedCommandDistribution bdc = new BalancedCommandDistribution(servers);
        LinkedHashMap<CommandInfo, SGASet> allocation = new LinkedHashMap<CommandInfo, SGASet>();
        for (SGASet sga : servers) {
            originalServers.put(sga.getName(), sga);
        }
        List<CommandInfo> greedyCommands = this.getCommandsOrderedByGreediness(commands);
        for (CommandInfo cmd : greedyCommands) {
            List<SGASet> filteresSGAs = SGAFilterByCommandRequirements.filter(cmd, updatedServers);
            if (filteresSGAs == null || filteresSGAs.isEmpty()) continue;
            List<SGASet> sgas = this.getSortedSGAByCPU(filteresSGAs);
            SGASet choosedServer = bdc.chooseLightest(sgas);
            allocation.put(cmd, (SGASet)originalServers.get(choosedServer.getName()));
            SGASet choosedServerCopy = new SGASet(this.updateSGAInfo(cmd, choosedServer.getMainInfo()), choosedServer.getName(), choosedServer.getEnabled(), choosedServer.getAlive(), choosedServer.hasDiskAccess(), choosedServer.isBackoffExpired(), choosedServer.getJobsInfo(), choosedServer.isCSFSEnabled(), null, System.currentTimeMillis());
            updatedServers.remove(choosedServer);
            updatedServers.add(choosedServerCopy);
        }
        return allocation;
    }

    private SGAInfo[] updateSGAInfo(CommandInfo cmd, SGAInfo info) {
        int ramInfo = 0;
        try {
            double sgaFreeRam = info.getRAMFreeMemoryMb();
            double commandUseRam = cmd.getConfigurator().getMemoryAmount();
            ramInfo = (int)(sgaFreeRam - commandUseRam);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        SGAInfo newInfo = new SGAInfo(info.getHostName(), info.getPlatformId(), info.getNumProcessors(), ramInfo, 0, info.getClockSpeedMHz(), info.getFileSeparator(), info.getProjectRootDirectory(), info.getAlgorithmRootDirectory(), info.getSandboxRootDirectory(), null);
        newInfo.setAlive(true);
        newInfo.setRAMFreeMemory((double)ramInfo);
        Set requirements = info.getRequirements();
        for (String req : requirements) {
            newInfo.addRequirement(req);
        }
        SGAInfo[] infos = new SGAInfo[]{newInfo};
        return infos;
    }

    private List<SGASet> getSortedSGAByCPU(List<SGASet> servers) {
        ArrayList<SGASet> sgasSets = new ArrayList<SGASet>();
        sgasSets.addAll(servers);
        Collections.sort(sgasSets, new SGASetCPUComparator());
        return sgasSets;
    }

    private List<CommandInfo> getCommandsOrderedByGreediness(List<CommandInfo> commands) {
        ArrayList<CommandInfo> orderedCopy = new ArrayList<CommandInfo>();
        for (CommandInfo cmd : commands) {
            orderedCopy.add(cmd);
        }
        Collections.sort(orderedCopy, Collections.reverseOrder(new CommandGreedinessComparator()));
        return orderedCopy;
    }
}

