/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.exception.PermissionException;
import csbase.logic.CommandInfo;
import csbase.logic.FailureFinalizationType;
import csbase.logic.Priority;
import csbase.logic.SGASet;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.schedulerservice.PercCPUPolicy;
import csbase.server.services.schedulerservice.PriorityQueue;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.SchedulerResourcesController;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.server.services.sgaservice.ProjectNotFoundException;
import csbase.server.services.sgaservice.SGANotAvailableException;
import csbase.server.services.sgaservice.SGAService;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Scheduler {
    private Thread schedulerThread;
    private boolean exitSchedulerThread;
    private final PriorityQueue commandQueue;
    private final SchedulerService service;
    private final SGAService sgaService;
    private final HashMap<String, Long> recentUsedServers;
    private final int sgaQuarantine;
    private final long queueProcessingInterval;
    private final int MaxSubmissionRetries;
    private SchedulerPolicyInterface schedPolicyInterface;
    private final String schedPolicyName;
    private static SchedulerResourcesController schedulerResourcesController;

    protected Scheduler(PriorityQueue commandQueue, long queueProcessingInterval, int submissionRetries, int sgaQuarantine, String schedPolicyName, boolean resourcesControl, String backupFilePath) {
        this.commandQueue = commandQueue;
        this.queueProcessingInterval = queueProcessingInterval;
        this.MaxSubmissionRetries = submissionRetries;
        this.sgaQuarantine = sgaQuarantine;
        this.schedPolicyName = schedPolicyName;
        this.sgaService = SGAService.getInstance();
        this.service = SchedulerService.getInstance();
        this.recentUsedServers = new HashMap();
        schedulerResourcesController = new SchedulerResourcesController(resourcesControl, backupFilePath);
    }

    protected void startScheduler() {
        this.loadSchedulerPolicy();
        this.schedulerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Scheduler.this.exitSchedulerThread) {
                    Server.logFineMessage("In\u00edcio do processamento, se houver comandos");
                    CommandInfo[] cmds = Scheduler.this.commandQueue.getAndWaitForCommands();
                    int numOfCommandsToSchedule = cmds.length;
                    LinkedList<CommandInfo> commandsToSchedule = new LinkedList<CommandInfo>();
                    block21: for (int i = 0; i < cmds.length && !Scheduler.this.exitSchedulerThread; ++i) {
                        CommandInfo cmd = cmds[i];
                        Service.setUserId(cmd.getUserId());
                        switch (cmd.getStatus()) {
                            case EXECUTING: 
                            case DOWNLOADING: 
                            case FINISHED: 
                            case SYSTEM_FAILURE: {
                                Scheduler.this.commandQueue.remove(cmd.getId());
                                --numOfCommandsToSchedule;
                                continue block21;
                            }
                            case SCHEDULED: {
                                if (cmd.getSubmissionAttempts() > Scheduler.this.MaxSubmissionRetries) {
                                    Scheduler.this.commandQueue.remove(cmd.getId());
                                    --numOfCommandsToSchedule;
                                    Scheduler.this.service.failCommand(cmd, FailureFinalizationType.MAX_SUBMISSION_RETRIES_REACHED);
                                    try {
                                        Server.logWarningMessage("Comando retirado da fila por excesso de tentativas de submiss\u00e3o. Plataforma " + cmd.getPlatformFilter() + " ID: " + cmd.getId() + "Algoritmo " + cmd.getConfigurator().getAlgorithmName());
                                    }
                                    catch (RemoteException e) {
                                        e.printStackTrace();
                                    }
                                    continue block21;
                                }
                                cmd.incSubmissionAttempts();
                                commandsToSchedule.add(cmd);
                                continue block21;
                            }
                        }
                    }
                    if (commandsToSchedule.isEmpty()) {
                        if (Scheduler.this.commandQueue.size() <= 0 || Scheduler.this.commandQueue.size() != numOfCommandsToSchedule) continue;
                        Server.logFineMessage("Ainda h\u00e1 comandos para processar. Fila em sleep.");
                        Scheduler.this.commandQueue.sleep(Scheduler.this.queueProcessingInterval);
                        continue;
                    }
                    Map serversChoosed = null;
                    serversChoosed = Scheduler.this.allocateSGA(commandsToSchedule);
                    if (serversChoosed == null) {
                        Server.logFineMessage("Nenhum SGA alocado");
                        if (Scheduler.this.commandQueue.size() <= 0 || Scheduler.this.commandQueue.size() != numOfCommandsToSchedule) continue;
                        Server.logFineMessage("Ainda h\u00e1 comandos para processar. Fila em sleep.");
                        Scheduler.this.commandQueue.sleep(Scheduler.this.queueProcessingInterval);
                        continue;
                    }
                    Set allocationSet = serversChoosed.entrySet();
                    for (Map.Entry entry : allocationSet) {
                        CommandInfo cmd = (CommandInfo)entry.getKey();
                        SGASet serverChoosed = (SGASet)entry.getValue();
                        Service.setUserId(cmd.getUserId());
                        if (Scheduler.this.isInQuarantine(serverChoosed.getName())) continue;
                        Server.logFineMessage("Servidor aprovado: " + serverChoosed);
                        try {
                            cmd.setSGAName(serverChoosed.getName());
                            schedulerResourcesController.makeReservation(cmd);
                            PriorityQueue priorityQueue = Scheduler.this.commandQueue;
                            synchronized (priorityQueue) {
                                if (Scheduler.this.commandQueue.getCommand(cmd.getId()) == null) {
                                    Server.logWarningMessage("O comando " + cmd.getId() + " n\u00e3o vai ser disparado porque j\u00e1 foi removido da fila");
                                } else {
                                    Scheduler.this.sgaService.executeCommand(cmd);
                                    Server.logFineMessage(MessageFormat.format("Comando {0} enviado ao SGA {1}", cmd.getId(), serverChoosed.getName()));
                                    Scheduler.this.recentUsedServers.put(serverChoosed.getName(), System.currentTimeMillis());
                                    commandsToSchedule.remove(cmd);
                                }
                            }
                        }
                        catch (SGANotAvailableException e) {
                            Server.logSevereMessage(String.format("Erro ao submeter o comando %s - %s.", cmd.getId(), cmd.getTip()), (Throwable)((Object)e));
                            Scheduler.this.service.failCommand(cmd, FailureFinalizationType.SGA_IS_NOT_AVAILABLE);
                        }
                        catch (ProjectNotFoundException e) {
                            Server.logSevereMessage(String.format("Erro ao submeter o comando %s - %s.", cmd.getId(), cmd.getTip()), (Throwable)((Object)e));
                            Scheduler.this.commandQueue.remove(cmd.getId());
                            --numOfCommandsToSchedule;
                            Scheduler.this.service.failCommand(cmd, FailureFinalizationType.PROJECT_NOT_FOUND);
                        }
                        catch (PermissionException e) {
                            Server.logSevereMessage(String.format("Erro ao submeter o comando %s - %s.", cmd.getId(), cmd.getTip()), e);
                            Scheduler.this.commandQueue.remove(cmd.getId());
                            --numOfCommandsToSchedule;
                            Scheduler.this.service.failCommand(cmd, FailureFinalizationType.USER_WITHOUT_PERMISSION_FOR_EXECUTION);
                        }
                        catch (Exception e) {
                            Server.logSevereMessage(String.format("Erro ao submeter o comando %s - %s.", cmd.getId(), cmd.getTip()), e);
                            Scheduler.this.commandQueue.remove(cmd.getId());
                            --numOfCommandsToSchedule;
                            FailureFinalizationType.UNKNOWN.changeDescription(e.getMessage());
                            Scheduler.this.service.failCommand(cmd, FailureFinalizationType.UNKNOWN);
                        }
                        finally {
                            Service.setUserId(null);
                        }
                    }
                    for (CommandInfo cmd : commandsToSchedule) {
                        if (cmd.getPriority() != Priority.ROOT) continue;
                        Service.setUserId(cmd.getUserId());
                        Scheduler.this.commandQueue.remove(cmd.getId());
                        --numOfCommandsToSchedule;
                        Server.logWarningMessage("Falha ao disparar comando com prioridade ROOT. N\u00e3o foi encontrado um SGA dispon\u00edvel para atender a plataforma " + cmd.getPlatformFilter() + " do algoritmo usado no comando: " + cmd.getId());
                        Scheduler.this.service.failCommand(cmd, FailureFinalizationType.NO_SGA_AVAILABLE_TO_ROOT_COMMAND);
                        Service.setUserId(null);
                    }
                    if (Scheduler.this.commandQueue.size() <= 0 || Scheduler.this.commandQueue.size() != numOfCommandsToSchedule) continue;
                    Server.logFineMessage("Ainda h\u00e1 comandos para processar. Fila em sleep.");
                    Scheduler.this.commandQueue.sleep(Scheduler.this.queueProcessingInterval);
                }
            }
        });
        this.schedulerThread.setName(this.getClass().getSimpleName() + "::" + "SchedulerThread");
        this.schedulerThread.start();
    }

    private Map<CommandInfo, SGASet> allocateSGA(List<CommandInfo> cmds) {
        Vector<String> sgasNames = this.sgaService.getAllSGANames();
        List<String> serversFiltered = this.filterQuarantaineSGAs(sgasNames);
        if (serversFiltered == null || serversFiltered.isEmpty()) {
            return null;
        }
        LinkedList<SGASet> sgasSetsFiltered = new LinkedList<SGASet>();
        for (String name : serversFiltered) {
            sgasSetsFiltered.add(this.sgaService.getSGASet(name));
        }
        this.clearQuarantine();
        return this.schedPolicyInterface.chooseServer(cmds, sgasSetsFiltered);
    }

    protected void stopScheduler() {
        this.exitSchedulerThread = true;
    }

    private SchedulerPolicyInterface loadSchedulerPolicy() {
        try {
            Class<?> c = Class.forName(this.schedPolicyName);
            this.schedPolicyInterface = (SchedulerPolicyInterface)c.newInstance();
        }
        catch (Exception e) {
            this.schedPolicyInterface = new PercCPUPolicy();
            Server.logSevereMessage(String.format("Erro ao ativar a pol\u00edtica de escalonamento %s.", this.schedPolicyName), e);
        }
        Server.logInfoMessage("Classe de escalonamento instanciada: " + this.schedPolicyInterface.getClass().getName() + ".java.");
        return this.schedPolicyInterface;
    }

    private void clearQuarantine() {
        Iterator<Long> iterator = this.recentUsedServers.values().iterator();
        while (iterator.hasNext()) {
            Long quarantineExpirationTime = iterator.next();
            long now = System.currentTimeMillis();
            if (now - quarantineExpirationTime <= (long)this.sgaQuarantine) continue;
            iterator.remove();
        }
    }

    private List<String> filterQuarantaineSGAs(List<String> sgaNames) {
        if (sgaNames == null) {
            return null;
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String sgaName : sgaNames) {
            if (this.isInQuarantine(sgaName)) continue;
            filteredList.add(sgaName);
        }
        return filteredList.isEmpty() ? null : filteredList;
    }

    private boolean isInQuarantine(String sgaName) {
        if (!this.recentUsedServers.containsKey(sgaName)) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.sgaQuarantine > 0 && now - this.recentUsedServers.get(sgaName) <= (long)this.sgaQuarantine) {
            return true;
        }
        this.recentUsedServers.remove(sgaName);
        return false;
    }

    public static SchedulerResourcesController getSchedulerResourcesController() {
        return schedulerResourcesController;
    }
}

