/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.classadpolicies;

import condor.classad.AttrName;
import condor.classad.ClassAd;
import condor.classad.ClassAdParser;
import condor.classad.Constant;
import condor.classad.Expr;
import condor.classad.RecordExpr;
import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdMatchInfo;
import csbase.server.services.schedulerservice.classadpolicies.CommandRequirements;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class ClassAdManager {
    private HashMap<String, RecordExpr> sgasAds = new HashMap();
    private HashMap<String, RecordExpr> cmdsAds = new HashMap();
    private static final String defaultSGAAdDesc = "Requirements = true; Rank = int(4-other.priority); ";
    private static final String defaultCmdAdDesc_Rank = "Rank = int(other.freeRAMMemory); ";
    private ClassAdParser cap = new ClassAdParser();

    public ClassAdMatchInfo match(CommandInfo cmd, SGASet server) {
        RecordExpr cmdAd = this.getCmdAd(cmd);
        RecordExpr sgaAd = this.getSGAAd(server);
        if (cmdAd == null || sgaAd == null) {
            return new ClassAdMatchInfo(server, cmd, false, -1, -1);
        }
        int[] ranks = ClassAd.match((Expr)sgaAd, (Expr)cmdAd);
        if (ranks != null) {
            return new ClassAdMatchInfo(server, cmd, true, ranks[0], ranks[1]);
        }
        return new ClassAdMatchInfo(server, cmd, false, -1, -1);
    }

    private RecordExpr getCmdAd(CommandInfo cmd) {
        if (this.cmdsAds.containsKey(cmd.getId())) {
            return this.cmdsAds.get(cmd.getId());
        }
        RecordExpr ad = this.createCmdAd(cmd);
        if (ad != null) {
            this.cmdsAds.put(cmd.getId(), ad);
        }
        return ad;
    }

    private RecordExpr getSGAAd(SGASet server) {
        if (this.sgasAds.containsKey(server.getName())) {
            return this.sgasAds.get(server.getName());
        }
        RecordExpr ad = this.createSGAAd(server);
        if (ad != null) {
            this.sgasAds.put(server.getName(), ad);
        }
        return ad;
    }

    public RecordExpr alterSGAAd(SGASet server) {
        if (!this.sgasAds.containsKey(server.getName())) {
            return null;
        }
        RecordExpr ad = this.getSGAAd(server);
        ad.removeAttribute(AttrName.fromString((String)"freeRAMMemory"));
        ad.insertAttribute("freeRAMMemory", (Expr)Constant.getInstance((double)server.getRAMFreeMemoryMb()));
        return ad;
    }

    private RecordExpr createSGAAd(SGASet server) {
        this.cap.reset(this.getSGAAdDesc(server));
        try {
            return (RecordExpr)this.cap.parse();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return null;
        }
    }

    private RecordExpr createCmdAd(CommandInfo cmd) {
        this.cap.reset(this.getCommandAdDesc(cmd));
        try {
            return (RecordExpr)this.cap.parse();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getSGAAdDesc(SGASet sgaSet) {
        StringBuilder descBuilder = new StringBuilder("[");
        descBuilder.append(defaultSGAAdDesc);
        this.appendAdInfo(descBuilder, "cpuLoad", sgaSet.getCPULoad1());
        this.appendAdInfo(descBuilder, "numProcessors", sgaSet.getNumProcessors());
        this.appendAdInfo(descBuilder, "name", sgaSet.getName());
        this.appendAdInfo(descBuilder, "platform", sgaSet.getPlatformId());
        this.appendAdInfo(descBuilder, "ramMemory", sgaSet.getRAMMemoryInfoMb());
        this.appendAdInfo(descBuilder, "swapMemory", sgaSet.getSwapMemoryInfoMb());
        this.appendAdInfo(descBuilder, "freeRAMMemory", sgaSet.getRAMFreeMemoryMb());
        this.appendAdInfo(descBuilder, "freeSwapMem", sgaSet.getSwapFreeMemory());
        this.appendSGAResources(sgaSet, descBuilder);
        descBuilder.append("]");
        return descBuilder.toString();
    }

    private void appendSGAResources(SGASet sgaSet, StringBuilder builder) {
        builder.append("resources = {");
        Set resources = sgaSet.getAllInfo()[0].getRequirements();
        for (String res : resources) {
            builder.append("\"");
            builder.append(res);
            builder.append("\", ");
        }
        builder.append("}; ");
    }

    private String getCommandAdDesc(CommandInfo cmd) {
        String ad = (String)cmd.getExtraPropertiesMap().get("ClassAdDesc");
        if (ad != null) {
            return ad;
        }
        CommandRequirements cmdReqs = this.getCommandRequirements(cmd);
        StringBuilder descBuilder = new StringBuilder("[");
        descBuilder.append(defaultCmdAdDesc_Rank);
        this.appendAdInfo(descBuilder, "id", cmd.getId());
        this.appendAdInfo(descBuilder, "priority", cmd.getPriority().ordinal());
        this.appendCommandSupportedPlatforms(cmd, cmdReqs.platforms, descBuilder);
        this.appendCommandRequirements(cmd, cmdReqs.memoryAmount, cmdReqs.cpuAmount, cmdReqs.requirements, descBuilder);
        descBuilder.append("]");
        return descBuilder.toString();
    }

    private void appendCommandSupportedPlatforms(CommandInfo cmd, Vector<String> platforms, StringBuilder builder) {
        builder.append("supportedPlatforms = {");
        HashSet<String> supportedPlatforms = new HashSet<String>();
        if (cmd.getPlatformFilter() != null) {
            supportedPlatforms.add(cmd.getPlatformFilter());
        } else {
            supportedPlatforms.addAll(platforms);
        }
        for (String platform : supportedPlatforms) {
            builder.append("\"");
            builder.append(platform);
            builder.append("\", ");
        }
        builder.append("}; ");
    }

    private CommandRequirements getCommandRequirements(CommandInfo cmd) {
        CommandRequirements cmdReqs = new CommandRequirements();
        try {
            AlgorithmConfigurator configurator = cmd.getConfigurator();
            configurator.updateAlgorithmVersion();
            Set platformsSet = configurator.getPlatforms();
            String platformRestriction = cmd.getPlatformFilter();
            cmdReqs.platforms = new Vector();
            if (platformRestriction == null) {
                cmdReqs.platforms.addAll(platformsSet);
            } else if (platformsSet.contains(platformRestriction)) {
                cmdReqs.platforms.add(platformRestriction);
            } else {
                cmdReqs.platforms = new Vector();
            }
            cmdReqs.cpuAmount = configurator.getCpuAmount();
            cmdReqs.memoryAmount = configurator.getMemoryAmount();
            cmdReqs.requirements = configurator.getRequirements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String reqMemStr = (String)cmd.getExtraPropertiesMap().get("RequiredMemory");
        if (reqMemStr != null) {
            try {
                cmdReqs.memoryAmount = Integer.parseInt(reqMemStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return cmdReqs;
    }

    private void appendCommandRequirements(CommandInfo cmd, float memoryAmount, float cpuAmount, Set<String> requirements, StringBuilder builder) {
        String demandedSGA;
        builder.append("Requirements = member(other.platform, self.supportedPlatforms)");
        if (memoryAmount > 0.0f) {
            builder.append("&& other.freeRAMMemory>");
            builder.append(memoryAmount);
        }
        if (cpuAmount > 0.0f) {
            builder.append("&& other.numProcessors>");
            builder.append(cpuAmount);
        }
        if (!requirements.isEmpty()) {
            for (String req : requirements) {
                builder.append("&& member(\"");
                builder.append(req.toUpperCase());
                builder.append("\", other.resources)");
            }
        }
        if ((demandedSGA = cmd.getSGAName()) != null && !demandedSGA.isEmpty()) {
            builder.append("&& other.name==\"");
            builder.append(demandedSGA);
            builder.append("\"");
        }
        builder.append(";");
    }

    private void appendAdInfo(StringBuilder builder, String infoKey, String infoValue) {
        builder.append(infoKey);
        builder.append(" = \"");
        builder.append(infoValue);
        builder.append("\"; ");
    }

    private void appendAdInfo(StringBuilder builder, String infoKey, double infoValue) {
        builder.append(infoKey);
        builder.append(" = ");
        builder.append(infoValue);
        builder.append("; ");
    }
}

