/*
 * Decompiled with CFR 0.152.
 */
package csbase.servlet;

import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import csbase.exception.HttpServiceException;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.HttpServiceInterface;
import csbase.remote.ServerEntryPoint;
import csbase.servlet.AbstractServlet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.Naming;
import java.util.Date;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServlet
extends AbstractServlet {
    private int fileSize;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.fileSize = Integer.parseInt(config.getInitParameter("fileSize"));
        }
        catch (NumberFormatException e) {
            this.fileSize = 102400;
        }
    }

    private HttpServiceInterface getHttpService() {
        try {
            String addr = String.valueOf(this.getRMIpath()) + "Server";
            ClientRemoteLocator.server = (ServerEntryPoint)Naming.lookup(addr);
            ClientRemoteLocator.httpService = ClientRemoteLocator.server.fetchHttpService();
            return ClientRemoteLocator.httpService;
        }
        catch (Exception e) {
            System.out.println(new Date() + " - Problema na comunica\u00e7\u00e3o com o servidor - " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    private String getAccessCode(HttpServletRequest request) {
        String reqParameters = request.getPathInfo();
        if (reqParameters == null) {
            return null;
        }
        String[] params = reqParameters.split("/", 3);
        if (params == null) {
            return null;
        }
        return params[1];
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!this.hasPropertiesFile() && !this.loadPropertiesFile()) {
            this.messageError(response, "Arquivo de propriedades System.properties n\u00e3o foi encontrado.");
            return;
        }
        try {
            String line;
            String accessCode = this.getAccessCode(request);
            if (accessCode == null) {
                this.messageError(response, "Falha na obten\u00e7\u00e3o do c\u00f3digo de acesso.");
                return;
            }
            HttpServiceInterface httpService = this.getHttpService();
            if (httpService == null) {
                this.messageError(response, "Problema na comunica\u00e7\u00e3o com o servidor");
                return;
            }
            if (httpService.getFilePath(accessCode) == null) {
                this.messageError(response, "Acesso Negado");
                return;
            }
            String presentationPath = httpService.getPresentationPath(accessCode);
            if (presentationPath == null) {
                this.messageError(response, "Falha na leitura da p\u00e1gina de upload");
                return;
            }
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            FileReader fr = new FileReader(presentationPath);
            BufferedReader bf = new BufferedReader(fr);
            while ((line = bf.readLine()) != null) {
                out.println(line);
            }
            out.close();
        }
        catch (IOException e) {
            this.messageError(response, "Erro na constru\u00e7\u00e3o do formulario. <br>Mensagem de erro:<br>" + e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!this.hasPropertiesFile() && !this.loadPropertiesFile()) {
            this.messageError(response, "Arquivo de propriedades System.properties n\u00e3o foi encontrado.");
            return;
        }
        try {
            String accessCode = this.getAccessCode(request);
            if (accessCode == null) {
                this.messageError(response, "Falha na obten\u00e7\u00e3o do c\u00f3digo de acesso.");
                return;
            }
            HttpServiceInterface httpService = this.getHttpService();
            if (httpService == null) {
                this.messageError(response, "Problema na comunica\u00e7\u00e3o com o servidor");
                return;
            }
            String absolutePath = httpService.getFilePath(accessCode);
            if (absolutePath == null) {
                this.messageError(response, "Acesso Negado");
                return;
            }
            String resultPath = httpService.getResultPath(accessCode);
            if (resultPath == null) {
                this.messageError(response, "Falha na leitura da p\u00e1gina de upload");
                return;
            }
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            if (this.sendFile(request, response, httpService, absolutePath, accessCode)) {
                String line;
                FileReader fr = new FileReader(resultPath);
                BufferedReader bf = new BufferedReader(fr);
                while ((line = bf.readLine()) != null) {
                    out.println(line);
                }
            } else {
                out.println("<html>");
                out.println(" <head><title>Upload de Arquivos</title></head>");
                out.println(" <body bgcolor=\"#EAEAEA\">");
                out.println(" <br><br><br><br><br><br><br>  <table align=\"center\"> ");
                out.println("  <tr>");
                out.println("  <td align=\"center\"><b>Houve algum problema. Verifique j\u00e1 existe um arquivo com o mesmo nome e tente novamente.</b></td>");
                out.println("    </tr>");
                out.println(" </table></body>");
                out.println("</html>");
            }
            out.close();
        }
        catch (IOException e) {
            this.messageError(response, "Erro na transf\u00eancia do arquivo. <br>Mensagem de erro: <br>" + e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendFile(HttpServletRequest req, HttpServletResponse res, HttpServiceInterface httpService, String absolutePath, String accessCode) {
        String absPath = absolutePath;
        FilePart fp = null;
        File arq = null;
        boolean sendRedirect = false;
        boolean sendFile = false;
        String redirect = "";
        try {
            MultipartParser mp = new MultipartParser(req, this.fileSize);
            while (true) {
                Part part;
                if ((part = mp.readNextPart()) == null) {
                    if (!sendFile) return sendFile;
                    if (!sendRedirect) return sendFile;
                    res.sendRedirect(redirect);
                    return sendFile;
                }
                if (part.isFile()) {
                    fp = (FilePart)part;
                    String fn = fp.getFileName();
                    if (httpService.isDirectory(accessCode)) {
                        if (!httpService.createFile(accessCode, fn)) {
                            return false;
                        }
                        absPath = String.valueOf(absPath) + File.separator + fn;
                    }
                    if (fn == null) continue;
                    arq = new File(absPath);
                    fp.writeTo(arq);
                    if (httpService.finishUpload(accessCode, fn)) {
                        sendFile = true;
                    }
                    System.out.println(new Date() + " - Descarregando upload da URL '" + req.getRequestURI() + "' em '" + arq + "'");
                    continue;
                }
                if (!part.isParam()) continue;
                ParamPart param = (ParamPart)part;
                String paramName = param.getName();
                String stringValue = param.getStringValue();
                if (paramName == null || !paramName.equals("sendRedirect") || stringValue == null || stringValue.trim().isEmpty()) continue;
                sendRedirect = true;
                redirect = stringValue;
            }
        }
        catch (IOException e) {
            StringBuffer messageBuilder = new StringBuffer();
            messageBuilder.append("Falha no upload.");
            messageBuilder.append("<br> Verifique se o arquivo escolhido \u00e9 maior que ");
            messageBuilder.append(String.valueOf(this.fileSize / 1024) + "KB");
            messageBuilder.append("<br><br> Mensagem de erro: <br>");
            String exceptionMessage = e.getLocalizedMessage();
            exceptionMessage.replace("/n", "<br>");
            messageBuilder.append(exceptionMessage);
            String message = messageBuilder.toString();
            this.messageError(res, message);
            this.log(message, e);
            if (arq == null) return false;
            arq.delete();
            return false;
        }
        catch (HttpServiceException e) {
            StringBuffer messageBuilder = new StringBuffer();
            messageBuilder.append("Falha no upload.");
            messageBuilder.append("<br> Mensagem de erro: <br>");
            String exceptionMessage = e.getLocalizedMessage();
            exceptionMessage.replace("/n", "<br>");
            messageBuilder.append(exceptionMessage);
            String message = messageBuilder.toString();
            this.messageError(res, message);
            this.log(message, e);
            if (arq == null) return false;
            arq.delete();
            return false;
        }
    }

    private void messageError(HttpServletResponse response, String message) {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<HTML><HEAD><TITLE>Acesso invalido</TITLE><BODY bgcolor=\"#EAEAEA\"><b>" + message + "</b></BODY></HTML>");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

