/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Arrays;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.signature.Signature;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.digest.Digest;
import net.schmizz.sshj.transport.digest.SHA1;
import net.schmizz.sshj.transport.kex.DH;
import net.schmizz.sshj.transport.kex.KeyExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDHG
implements KeyExchange {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Transport trans;
    private final Digest sha1 = new SHA1();
    private final DH dh = new DH();
    private String V_S;
    private String V_C;
    private byte[] I_S;
    private byte[] I_C;
    private byte[] H;
    private PublicKey hostKey;

    @Override
    public byte[] getH() {
        return Arrays.copyOf(this.H, this.H.length);
    }

    @Override
    public BigInteger getK() {
        return this.dh.getK();
    }

    @Override
    public Digest getHash() {
        return this.sha1;
    }

    @Override
    public PublicKey getHostKey() {
        return this.hostKey;
    }

    @Override
    public void init(Transport trans, String V_S, String V_C, byte[] I_S, byte[] I_C) throws GeneralSecurityException, TransportException {
        this.trans = trans;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = Arrays.copyOf(I_S, I_S.length);
        this.I_C = Arrays.copyOf(I_C, I_C.length);
        this.sha1.init();
        this.initDH(this.dh);
        this.log.debug("Sending SSH_MSG_KEXDH_INIT");
        trans.write((SSHPacket)new SSHPacket(Message.KEXDH_INIT).putMPInt(this.dh.getE()));
    }

    @Override
    public boolean next(Message msg, SSHPacket packet) throws GeneralSecurityException, TransportException {
        byte[] sig;
        BigInteger f;
        byte[] K_S;
        if (msg != Message.KEXDH_31) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "Unexpected packet: " + (Object)((Object)msg));
        }
        this.log.debug("Received SSH_MSG_KEXDH_REPLY");
        try {
            K_S = packet.readBytes();
            f = packet.readMPInt();
            sig = packet.readBytes();
            this.hostKey = new Buffer.PlainBuffer(K_S).readPublicKey();
        }
        catch (Buffer.BufferException be) {
            throw new TransportException(be);
        }
        this.dh.computeK(f);
        Buffer.PlainBuffer buf = (Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.V_C)).putString(this.V_S)).putString(this.I_C)).putString(this.I_S)).putString(K_S)).putMPInt(this.dh.getE())).putMPInt(f)).putMPInt(this.dh.getK());
        this.sha1.update(buf.array(), buf.rpos(), buf.available());
        this.H = this.sha1.digest();
        Signature signature = (Signature)Factory.Named.Util.create(this.trans.getConfig().getSignatureFactories(), KeyType.fromKey(this.hostKey).toString());
        signature.init(this.hostKey, null);
        signature.update(this.H, 0, this.H.length);
        if (!signature.verify(sig)) {
            throw new TransportException(DisconnectReason.KEY_EXCHANGE_FAILED, "KeyExchange signature verification failed");
        }
        return true;
    }

    protected abstract void initDH(DH var1) throws GeneralSecurityException;
}

