/**
 * $Id: SGEDOMReader.java 167543 2015-08-18 15:47:17Z fpina $
 */

package csbase.sga.ssh.sge.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author Tecgraf
 */
public class SGEDOMReader {
  public List<Map<String, String>> read(String xml) {
    final List<Map<String, String>> jobs = new LinkedList<>();
    try {
      DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
      DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
      Document doc = dBuilder.parse(new ByteArrayInputStream(xml.getBytes()));

      //optional, but recommended
      //read this - http://stackoverflow.com/questions/13786607/normalization-in-dom-parsing-with-java-how-does-it-work
      doc.getDocumentElement().normalize();

      NodeList nList = doc.getElementsByTagName("job_list");
      for (int temp = 0; temp < nList.getLength(); temp++) {
        Map<String, String> currebtJob = new HashMap<>();
        Node nNode = nList.item(temp);
        if (nNode.getNodeType() == Node.ELEMENT_NODE) {
          Element eElement = (Element) nNode;
          currebtJob.put("state", eElement.getAttribute("state"));
          currebtJob.put(
            "JB_job_number", eElement.getElementsByTagName(
              "JB_job_number").item(0).getTextContent());
          jobs.add(currebtJob);
        }
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }

    return jobs;
  }
}
