/*
 * Decompiled with CFR 0.152.
 */
package csbase.sshclient;

import csbase.sshclient.CommandResult;
import csbase.sshclient.SSHClientException;
import csbase.sshclient.SSHTunnel;
import csbase.sshclient.SSHUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHClient {
    private static final long RETRY_WAIT_TIME = 2000L;
    private static final int MAX_RETRIES = 10;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String host;
    private int port;
    private SSHTunnel tunnel;
    private net.schmizz.sshj.SSHClient client;
    private SFTPClient sftp;
    private Session session;

    public SSHClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.client = new net.schmizz.sshj.SSHClient();
        SSHUtils.addBlankHostKeyVerifier(this.client);
    }

    public void connect(String userName, String privateKeyFilePath) throws SSHClientException {
        this.connect(userName, privateKeyFilePath, 0);
    }

    public void connect(String userName, String privateKeyFilePath, int timeOut) throws SSHClientException {
        if (this.client.isConnected()) {
            return;
        }
        if (userName == null || userName.isEmpty()) {
            this.log.error("User name is null or empty");
            return;
        }
        if (privateKeyFilePath == null || privateKeyFilePath.isEmpty()) {
            this.log.error("Private key path is null or empty");
            return;
        }
        File privateKey = new File(privateKeyFilePath);
        if (!privateKey.exists()) {
            this.log.error("Private key does not exist");
            return;
        }
        if (timeOut > 0) {
            this.client.setConnectTimeout(timeOut);
        }
        int attempt = 0;
        while (true) {
            try {
                String msg;
                if (this.tunnel != null) {
                    this.client.connect(this.tunnel.getLocalhost(), this.tunnel.getLocalPort());
                    msg = MessageFormat.format("Connected {0}:{1}", this.tunnel.getLocalhost(), this.tunnel.getLocalPort());
                    this.log.info(msg);
                } else {
                    this.client.connect(this.host, this.port);
                    msg = MessageFormat.format("Connected {0}:{1}", this.host, this.port);
                    this.log.info(msg);
                }
                OpenSSHKeyFile keyProv = new OpenSSHKeyFile();
                keyProv.init(privateKey);
                this.client.authPublickey(userName, new KeyProvider[]{keyProv});
                String msg2 = MessageFormat.format("Authenticated {0} {1}", userName, privateKeyFilePath);
                this.log.info(msg2);
            }
            catch (Exception e) {
                this.log.info("Failed establishing a connection", (Throwable)e);
                if (attempt++ > 10) {
                    this.log.error("Max retries reached while trying establishing a connection", (Throwable)e);
                    break;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {}
                continue;
            }
            break;
        }
        try {
            this.sftp = this.client.newSFTPClient();
        }
        catch (IOException e) {
            this.log.warn("Error while creating a SFTP client", (Throwable)e);
        }
    }

    public void createTunnel(String tunnelHost, int tunnelPort, String tunnelUserName, String tunnelPrivateKeyFilePath, int localPort) throws SSHClientException {
        this.createTunnel(tunnelHost, tunnelPort, tunnelUserName, tunnelPrivateKeyFilePath, localPort, 0);
    }

    public void createTunnel(String tunnelHost, int tunnelPort, String tunnelUserName, String tunnelPrivateKeyFilePath, int localPort, int localRange) throws SSHClientException {
        this.tunnel = new SSHTunnel(tunnelHost, tunnelPort, tunnelUserName, tunnelPrivateKeyFilePath, this.host, this.port, localPort, localRange);
    }

    public void disconnect() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (ConnectionException | TransportException e) {
                this.log.warn("Error while closing the session", e);
            }
            this.session = null;
        }
        if (this.sftp != null) {
            try {
                this.sftp.close();
            }
            catch (IOException e) {
                this.log.warn("Error while closing the SFTP client", (Throwable)e);
            }
            this.sftp = null;
        }
        try {
            this.client.disconnect();
        }
        catch (IOException e) {
            this.log.warn("Error while closing the SSHClient", (Throwable)e);
        }
        if (this.tunnel != null) {
            this.tunnel.close();
        }
    }

    public boolean isConnected() {
        if (this.tunnel != null) {
            return this.tunnel.isConnected() && this.client.isConnected();
        }
        return this.client.isConnected();
    }

    public CommandResult execute(String command) throws IOException {
        this.session = this.client.startSession();
        Session.Command cmd = this.session.exec(command);
        String output = IOUtils.readFully((InputStream)cmd.getInputStream()).toString();
        String error = IOUtils.readFully((InputStream)cmd.getErrorStream()).toString();
        cmd.join();
        return new CommandResult(cmd.getExitStatus(), output, error);
    }

    public void remove(String remotePath) throws IOException {
        if (this.sftp.type(remotePath).equals((Object)FileMode.Type.DIRECTORY)) {
            List infoList = this.sftp.ls(remotePath);
            for (RemoteResourceInfo info : infoList) {
                this.remove(info.getPath());
            }
            this.sftp.rmdir(remotePath);
        } else {
            this.sftp.rm(remotePath);
        }
    }

    public void createDirectory(String remotDirectoryPath) throws IOException {
        this.sftp.mkdirs(remotDirectoryPath);
    }

    public boolean stat(String remotePath) throws IOException {
        return this.sftp.statExistence(remotePath) != null;
    }

    public void download(String localFilePath, String remoteFilePath) throws IOException {
        File file = new File(localFilePath);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileSystemFile localFile = new FileSystemFile(localFilePath);
        this.sftp.get(remoteFilePath, (LocalDestFile)localFile);
    }

    public void upload(String localFilePath, String remoteFilePath) throws IOException {
        this.sftp.mkdirs(new File(remoteFilePath).getParent());
        FileSystemFile localFile = new FileSystemFile(localFilePath);
        this.sftp.put((LocalSourceFile)localFile, remoteFilePath);
        this.setMode(remoteFilePath, localFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMode(String remotePath, String localPath) throws IOException {
        File file = new File(localPath);
        int perm = 0;
        if (file.isDirectory()) {
            perm = 45;
        } else if (file.isFile()) {
            perm = 36;
        }
        perm += file.canExecute() ? 64 : 0;
        perm += file.canWrite() ? 128 : 0;
        this.sftp.chmod(remotePath, perm += file.canRead() ? 256 : 0);
        if (this.sftp.type(remotePath).equals((Object)FileMode.Type.DIRECTORY)) {
            List infoList = this.sftp.ls(remotePath);
            for (RemoteResourceInfo info : infoList) {
                this.setMode(remotePath + File.separator + info.getName(), localPath + File.separator + info.getName());
            }
        }
    }

    public Map<String, Long> listFiles(String remotePath) throws IOException {
        HashMap<String, Long> files = new HashMap<String, Long>();
        for (RemoteResourceInfo info : this.sftp.ls(remotePath)) {
            if (info.isDirectory()) {
                files.putAll(this.listFiles(info.getPath()));
                continue;
            }
            files.put(info.getPath(), info.getAttributes().getMtime());
        }
        return files;
    }

    public Map<String, Long> listFilesAndDirectories(String remotePath) throws IOException {
        HashMap<String, Long> files = new HashMap<String, Long>();
        for (RemoteResourceInfo info : this.sftp.ls(remotePath)) {
            if (info.isDirectory()) {
                files.put(info.getPath(), info.getAttributes().getMtime());
                files.putAll(this.listFiles(info.getPath()));
                continue;
            }
            files.put(info.getPath(), info.getAttributes().getMtime());
        }
        return files;
    }

    public boolean isTunneled() {
        return this.tunnel != null && this.tunnel.isConnected();
    }
}

