/*
 * Decompiled with CFR 0.152.
 */
package csbase.sshclient;

import csbase.sshclient.SSHClientException;
import csbase.sshclient.SSHUtils;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.text.MessageFormat;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.LocalPortForwarder;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSHTunnel
implements AutoCloseable {
    private static final String LOCALHOST = "localhost";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int localPort;
    private final SSHClient sshTunnelClient;
    private final ServerSocket tunnelSocket;

    public SSHTunnel(final String reachableHost, final int reachablePort, final String reachableUserName, final String reachablePrivateKeyFilePath, final String unreachableHost, final int unreachablePort, final int localPort, int localRange) throws SSHClientException {
        if (reachableHost == null || reachableHost.isEmpty()) {
            throw new SSHClientException("Reachable host is null or empty");
        }
        if (reachablePort <= 0) {
            throw new SSHClientException("Invalid reachable port");
        }
        if (reachableUserName == null || reachableUserName.isEmpty()) {
            throw new SSHClientException("User name is null or empty");
        }
        if (reachablePrivateKeyFilePath == null || reachablePrivateKeyFilePath.isEmpty()) {
            throw new SSHClientException("Private key path is null or empty");
        }
        File reachablePrivateKey = new File(reachablePrivateKeyFilePath);
        if (!reachablePrivateKey.exists()) {
            throw new SSHClientException("Private key does not exist");
        }
        if (unreachableHost == null || unreachableHost.isEmpty()) {
            throw new SSHClientException("Unreachable Host is null or empty");
        }
        if (unreachablePort <= 0) {
            throw new SSHClientException("Invalid unreachable port");
        }
        if (localPort <= 0) {
            throw new SSHClientException("Invalid local port");
        }
        if (localRange < 0) {
            throw new SSHClientException("Invalid local port range");
        }
        int initLocalPortRange = localPort;
        int endLocalPortRange = localPort + localRange;
        this.sshTunnelClient = new SSHClient();
        SSHUtils.addBlankHostKeyVerifier(this.sshTunnelClient);
        OpenSSHKeyFile keyProv = new OpenSSHKeyFile();
        keyProv.init(reachablePrivateKey);
        try {
            this.sshTunnelClient.connect(reachableHost, reachablePort);
            this.sshTunnelClient.authPublickey(reachableUserName, new KeyProvider[]{keyProv});
            this.tunnelSocket = this.createServerSocket(LOCALHOST, initLocalPortRange, endLocalPortRange);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format("Error while creating tunnel {0}:{1} -> {4}:{5} at local port {6} [{2} {3}]", reachableHost, reachablePort, reachableUserName, reachablePrivateKeyFilePath, unreachableHost, unreachablePort, Integer.toString(localPort));
            throw new SSHClientException(errMsg, e);
        }
        final LocalPortForwarder.Parameters params = new LocalPortForwarder.Parameters(LOCALHOST, this.tunnelSocket.getLocalPort(), unreachableHost, unreachablePort);
        Thread tunnelThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String msg = MessageFormat.format("Creating tunnel {0}:{1} -> {4}:{5} at local port {6} [{2} {3}]", reachableHost, reachablePort, reachableUserName, reachablePrivateKeyFilePath, unreachableHost, unreachablePort, Integer.toString(localPort));
                    SSHTunnel.this.log.info(msg);
                    SSHTunnel.this.sshTunnelClient.newLocalPortForwarder(params, SSHTunnel.this.tunnelSocket).listen();
                }
                catch (SocketException e) {
                }
                catch (IOException e) {
                    SSHTunnel.this.log.error("Error while forwarding port", (Throwable)e);
                }
                finally {
                    try {
                        SSHTunnel.this.sshTunnelClient.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        tunnelThread.start();
    }

    public SSHTunnel(String reachableHost, int reachablePort, String reachableUserName, String reachablePrivateKeyFilePath, String unreachableHost, int unreachablePort, int localPort) throws SSHClientException {
        this(reachableHost, reachablePort, reachableUserName, reachablePrivateKeyFilePath, unreachableHost, unreachablePort, localPort, 0);
    }

    private ServerSocket createServerSocket(String host, int initPortRange, int endPortRange) throws IOException, SSHClientException {
        int port = initPortRange;
        while (true) {
            try {
                ServerSocket serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress(host, port));
                this.localPort = port;
                return serverSocket;
            }
            catch (BindException e) {
                try {
                    if (++port > endPortRange) {
                        if (initPortRange == endPortRange) {
                            String msg = MessageFormat.format("Port {0} is in use.", initPortRange);
                            throw new SSHClientException(msg);
                        }
                        String msg = MessageFormat.format("All local ports in the range [{0} - {1}] are in use.", initPortRange, endPortRange);
                        throw new SSHClientException(msg);
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                }
                continue;
            }
            break;
        }
    }

    public String getLocalhost() {
        return LOCALHOST;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public boolean isConnected() {
        return this.sshTunnelClient.isConnected();
    }

    @Override
    public void close() {
        Thread stopTunnelSocketThread = new Thread(){

            @Override
            public void run() {
                try {
                    SSHTunnel.this.tunnelSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        stopTunnelSocketThread.run();
    }
}

