package csbase.test.unit;

import java.io.FileInputStream;
import java.util.Properties;

/**
 * A configurao do servidor.
 */
public class TestConfig {
  /** As propriedades de configurao para execucao dos Testes. */
  private static Properties properties = new Properties();

  /** O nome do arquivo de onde as propriedades foram carregadas */
  private static String propertiesFileName = null;

  /** Nome default do arquivo de configuracao para os testes */
  public static final String TEST_CONFIG_FILE = "test/properties/test.properties";

  /** Propriedade que define o nome do servidor ao qual o cliente se conecta. */
  public static final String SERVER_PROP = "server";

  /** Propriedade que define o login do usurio. */
  public static final String LOGIN_PROP = "user.login";

  /** Propriedade que define a senha do usurio */
  public static final String PASSWORD_PROP = "user.password";

  /** Propriedade que define o diretrio do sistema. */
  public static final String SYSTEM_DIR_PROP = "system.dir";

  /** Propriedade que define o diretrio do csbase. */
  public static final String CSBASE_DIR_PROP = "csbase.dir";

  /** Propriedade que define o idioma do locale. */
  public static final String LOCALE_LANGUAGE_PROP = "locale.language";

  /** Propriedade que define o pas do locale. */
  public static final String LOCALE_COUNTRY_PROP = "locale.country";
  
  /**
   * Propriedade que define o valor default do tempo de espera para logar
   * no servidor em segundos.
   */
  public static final String SETUP_SLEEP_PROP = "setup.sleep";

  /** Define o valor default do servidor ao qual o cliente se conecta. */
  public static final String SERVER_DEFAULT = "localhost:1099";

  /** Define o valor default do login do usurio. */
  public static final String LOGIN_DEFAULT = "admin";

  /** Define a senha default do usurio */
  public static final String PASSWORD_DEFAULT = "1234";

  /** Define o diretrio default do sistema. */
  public static final String SYSTEM_DIR_DEFAULT = ".";

  /** Define o diretrio defaultdo csbase. */
  public static final String CSBASE_DIR_DEFAULT = "../csbase";

  /** Define o idioma defautl do locale. */
  public static final String LOCALE_LANGUAGE_DEFAULT = "pt";

  /** Define o pas deafult do locale. */
  public static final String LOCALE_COUNTRY_DEFAULT = "BR";
  
  /**
   * Define o valor default do tempo de espera para logar no servidor em
   * segundos.
   */
  public static final int SETUP_SLEEP_DEFAULT = 18000; //3 segundos

  /**
   * Inicializao das propriedades.
   */
  public static boolean init() {
    propertiesFileName = System.getProperty("TestConfig.propFilePath");
    if (propertiesFileName == null){
      propertiesFileName = TEST_CONFIG_FILE;
    }
    System.out.println("Arquivo de Propriedades:" + propertiesFileName);

    /* Inicializao das propriedades */
    return loadProperties();
  }

  /**
   * Recupera uma propriedade
   * 
   * @param key a identificao da propriedade
   * 
   * @return o valor da propriedade como uma string ou null (caso a propriedade
   *         no seja encontrada).
   */
  public static String getProperty(String key) {
    if (properties == null) {
      return null;
    }
    return properties.getProperty(key);
  }

  /**
   * Recupera uma propriedade do servidor.
   * 
   * @param key a identificao da propriedade
   * @param def um valor default para ser retornado.
   * 
   * @return o valor da propriedade como uma string ou o valor default caso a
   *         propriedade no seja encontrada
   */
  public static String getProperty(String key, String def) {
    if (properties == null) {
      return def;
    }
    String value = properties.getProperty(key, def);
    return value;
  }

  /**
   * Recupera uma propriedade do servidor. A propriedade  usada como um valor
   * inteiro.
   * 
   * @param key a identificao da propriedade
   * @param def um valor default para ser retornado.
   */
  public static int getIntProperty(String key, int def) {
    if (properties == null) {
      return def;
    }
    try {
      return Integer.parseInt(properties.getProperty(key));
    } catch (Exception e) {
      return def;
    }
  }

  /**
   * Recupera uma propriedade do servidor. A propriedade  usada como um valor
   * decimal.
   * 
   * @param key a identificao da propriedade
   * @param def um valor default para ser retornado.
   */
  public static float getFloatProperty(String key, float def) {

    if (properties == null) {
      return def;
    }
    try {
      return Float.parseFloat(properties.getProperty(key));
    } catch (Exception e) {
      return def;
    }
  }

  /**
   * Recupera uma propriedade do servidor. A propriedade  usada como um valor
   * inteiro.
   * 
   * @param key a identificao da propriedade
   */
  public static Integer getIntegerProperty(String key, int def) {

    if (properties == null) {
      return new Integer(def);
    }
    try {
      return Integer.decode(properties.getProperty(key));
    } catch (Exception e) {
      return new Integer(def);
    }
  }

  /**
   * Carregamento das propriedades do servidor.
   * 
   * @return um flag indicativo para o correto carregamento.
   */
  public static boolean loadProperties() {
    try {
      if (propertiesFileName == null){
        return false;
      }
      
      FileInputStream in = new FileInputStream(propertiesFileName);
      properties.load(in);
      in.close();
    } catch (Exception e) {
      e.printStackTrace();
      return false;
    }
    return true;
  }

  /**
   * Altera uma propriedade previamente carregada pelo servidor de acesso ou
   * insere uma nova propriedade que nao foi definida no arquivo de
   * configuracao.
   * 
   * @return o valor antigo da propriedade, se a propriedade for nova retorna
   *         null.
   */
  public static String setProperty(String key, String propertyVal) {
    String oldVal = properties.getProperty(key);
    properties.put(key, propertyVal);
    return oldVal;
  }

}
