/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.io.File;
import tecgraf.javautils.core.lng.LNG;

public class FileConfigConverter {
    private static boolean TEST_MODE = false;
    private static boolean VERBOSE_MODE = true;

    private static void verbose(String msg) {
        if (VERBOSE_MODE) {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        String dirPath = null;
        for (String arg : args) {
            if (arg.equals("-t")) {
                TEST_MODE = true;
                continue;
            }
            if (arg.equals("-v")) {
                VERBOSE_MODE = true;
                continue;
            }
            dirPath = arg;
        }
        if (dirPath == null) {
            System.out.println(LNG.get((String)"FileConfigConverter.error.dir.path.notfound"));
            return;
        }
        FileConfigConverter.substitutePath(dirPath);
    }

    private static void substitutePath(String dirPath) {
        System.out.println(LNG.get((String)"FileConfigConverter.dirpath.analyzing", (Object[])new String[]{dirPath}));
        File file = new File(dirPath);
        if (!file.exists()) {
            System.out.println(LNG.get((String)"FileConfigConverter.error.dir.inexistent", (Object[])new String[]{file.getAbsolutePath()}));
            return;
        }
        if (!file.isDirectory()) {
            System.out.println(LNG.get((String)"FileConfigConverter.error.dir.notadir", (Object[])new String[]{file.getAbsolutePath()}));
            return;
        }
        FileConfigConverter.substituteFile(file);
    }

    private static void substituteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            for (File f : children = file.listFiles()) {
                FileConfigConverter.substituteFile(f);
            }
        } else {
            String fileName = file.getName();
            if (FileConfigConverter.looksNewFormat(fileName)) {
                String path = file.getAbsolutePath();
                String msg = LNG.get((String)"FileConfigConverter.substitute.unaltered", (Object[])new String[]{path});
                FileConfigConverter.verbose(msg);
            } else if (FileConfigConverter.looksOldFormat(fileName)) {
                String pth2;
                String pth1;
                String newFileName = "." + fileName;
                File newFile = new File(file.getParent(), newFileName);
                if (newFile.exists()) {
                    String path = newFile.getAbsolutePath();
                    String msg = LNG.get((String)"FileConfigConverter.substitute.overwrote", (Object[])new String[]{path});
                    FileConfigConverter.verbose(msg);
                }
                if (!TEST_MODE) {
                    file.renameTo(newFile);
                    pth1 = file.getAbsolutePath();
                    pth2 = newFile.getAbsolutePath();
                    String msg = LNG.get((String)"FileConfigConverter.substitute.mv", (Object[])new String[]{pth1, pth2});
                    FileConfigConverter.verbose(msg);
                } else {
                    pth1 = file.getAbsolutePath();
                    pth2 = newFile.getAbsolutePath();
                    String msg = LNG.get((String)"FileConfigConverter.substitute.mv.simulation", (Object[])new String[]{pth1, pth2});
                    FileConfigConverter.verbose(msg);
                }
            }
        }
    }

    private static boolean looksOldFormat(String fileName) {
        boolean cs = fileName.endsWith(".csbase");
        boolean csb = fileName.endsWith(".csbase_description");
        boolean pt = fileName.startsWith(".");
        return !pt && (cs || csb);
    }

    private static boolean looksNewFormat(String fileName) {
        boolean cs = fileName.endsWith(".csbase");
        boolean csb = fileName.endsWith(".csbase_description");
        boolean pt = fileName.startsWith(".");
        return pt && (cs || csb);
    }
}

