/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import tecgraf.javautils.core.lng.LNG;

public class PermissionRefactor {
    private ObjectInputStream ois;
    private ObjectOutputStream oos;
    private final String CLASS = "class";

    public PermissionRefactor(String propertiesFilePath, String permissionFilePath) throws Exception {
        FileInputStream permission = new FileInputStream(permissionFilePath);
        this.ois = new ObjectInputStream(permission);
        Hashtable permHash = (Hashtable)this.ois.readObject();
        this.ois.close();
        Properties properties = this.loadProperties(propertiesFilePath);
        Enumeration keys = permHash.keys();
        boolean hasChanged = false;
        while (keys.hasMoreElements()) {
            Object id = keys.nextElement();
            Hashtable permissionHash = (Hashtable)permHash.get(id);
            System.out.println(LNG.get((String)"PermissionRefactor.key", (Object[])new String[]{id.toString()}));
            String className = (String)permissionHash.get("class");
            String name = (String)permissionHash.get("name");
            System.out.println(LNG.get((String)"PermissionRefactor.name", (Object[])new String[]{className, name}));
            String newValue = properties.getProperty(className, className);
            if (newValue.equals(className)) continue;
            permissionHash.put("class", newValue);
            permHash.put(id, permissionHash);
            hasChanged = true;
        }
        if (hasChanged) {
            FileOutputStream newPermission = new FileOutputStream(permissionFilePath + "_NEW");
            this.oos = new ObjectOutputStream(newPermission);
            this.oos.writeObject(permHash);
            this.oos.close();
        } else {
            System.out.println(LNG.get((String)"PermissionRefactor.permission.notmoved"));
            System.exit(1);
        }
    }

    private Properties loadProperties(String propertiesFilePath) throws Exception {
        FileInputStream input = new FileInputStream(propertiesFilePath);
        Properties prop = new Properties();
        prop.load(input);
        return prop;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println(LNG.get((String)"PermissionRefactor.usage"));
            System.exit(1);
        }
        try {
            new PermissionRefactor(args[0], args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

