/*
 * Decompiled with CFR 0.152.
 */
package csbase.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class StringUtils {
    private static Comparator<String> plainSortComparator;
    private static Collator plainSortCollator;

    public static List<String> split(String text, char delimiter) {
        ArrayList<String> splitted = new ArrayList<String>();
        int begin = 0;
        int cursor = text.indexOf(delimiter, begin);
        while (cursor > 0) {
            splitted.add(text.substring(begin, cursor));
            begin = cursor + 1;
            cursor = text.indexOf(delimiter, begin);
        }
        if (begin < text.length()) {
            splitted.add(text.substring(begin));
        }
        return splitted;
    }

    public static Collator getPlainSortCollator() {
        if (plainSortCollator == null) {
            plainSortCollator = (Collator)Collator.getInstance().clone();
            plainSortCollator.setStrength(2);
        }
        return plainSortCollator;
    }

    public static Comparator<String> getPlainSortComparator() {
        if (plainSortComparator == null) {
            plainSortComparator = new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return StringUtils.compare(o1, o2);
                }
            };
        }
        return plainSortComparator;
    }

    public static int compare(String s1, String s2) {
        return StringUtils.getPlainSortCollator().compare(s1, s2);
    }

    public static String[] sort(String[] array) {
        Arrays.sort(array, StringUtils.getPlainSortComparator());
        return array;
    }

    public static String convertToString(InputStream in) {
        if (in == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            return sb.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

