// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
#include <iostream>
#include <string.h>
#ifdef ORBACUS
#include <OB/CORBA.h>
#endif

#include "wioapi.h"
#include "wio.h"

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

using namespace std;
namespace wio = csbase::server::services::wioservice::idl;
using namespace wioapi;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

/**
 * Macro para fazer um log do programa na tela.
 */
#ifdef WIO_DEBUG
  #define LOG(str) cout << (str) << endl;
#else
  #define LOG(str)
#endif

/* ....................................................................... */
/**
 * Essa macro serve apenas para reduzir digitao na 
 * implementao dos mtodos.
 * @param code o codigo que lanar a execeo.
 * @param msg a o nome do mtodo que causou o erro.
 */
#define _TRY(code, method_name) \
  try{ \
    code; \
  } \
  catch (wioapi::Exception& we) { \
      cerr << "EXCEO WIO" << endl; \
      cerr << we.getServerMessage() << endl; \
      cerr << we.getClientMessage() << endl; \
      throw; \
  } \
  catch (wio::WIOServiceException& wse) { \
      cerr << "EXCEO WIO SERVICE" << endl; \
      cerr << wse.message << endl; \
      throw new wioapi::Exception(method_name, "Sem exceo no lado cliente", wse.message); \
  } \
  catch (CORBA::Exception& ce) { \
      cerr << "EXCEO CORBA" << endl; \
      cerr << ce << endl; \
      throw new wioapi::Exception(method_name, "Sem exceo no lado cliente", "Exceo CORBA detectada (sem informaes do servidor)"); \
  } \
  catch (...) { \
      cerr << "EXCEO" << endl; \
      throw new wioapi::Exception(method_name, "Exceo local genrica detectada no lado cliente", ""); \
  }

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

/* ....................................................................... */
/**
 *
 */
inline long minLong(long a, long b) {
  return (a < b ? a : b);
}

/* ....................................................................... */
/**
 *
 */
inline long long minLongLong(long long a, long long b) {
  return (a < b ? a : b);
}

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

/* ....................................................................... */
/**
 *
 */
inline bool booleanToBool(CORBA::Boolean b) {
	return b ? true : false;
}

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

/* ....................................................................... */
/**
 * Esta classe tem a implementacao dos metodos virtuais de WIOFileSystem
 */
class WIOFileSystemImpl : public WIOFileSystem {
   private:
	   wio::WIOFileSystem_var wioFileSystem;
      char* ior;

   public:
      char* getIOR(void);
      char* getSeparatorChar(void) const throw (wioapi::Exception*);
      char* getServerVersion(void) const throw (wioapi::Exception*);
      long getMaxReadKb(void) const throw (wioapi::Exception*);
      long getMaxWriteKb(void) const throw (wioapi::Exception*);
      long getMaxOpenedProjects(void) const throw (wioapi::Exception*);
      long getNumOpenedProjects(void) const throw (wioapi::Exception*);

	   char** getProjects(const char* userId, const char* passwd, long& qtd) 
         const throw (wioapi::Exception*);

	   SharedProjectInfo* getProjectsFromOthers(const char* userId, 
         const char* passwd, long& qtd) const throw (wioapi::Exception*);

	   WIOProject* openProject(const char* userId, const char* passwd, 
         const char* projectId) const throw (wioapi::Exception*);

	   WIOProject* openProjectFromOthers(const char* userId, const char* passwd, 
         const char* ownerId, const char* projectId) 
         const throw (wioapi::Exception*);

         char* preLogin2Web(const char* login, const char* password,
                            const char* projectName,
                            const WIOAlgorithmInfo& algorithmInfo)
	 const throw (wioapi::Exception*);

	   WIOFileSystemImpl(char* ior) throw (wioapi::Exception*);
	   ~WIOFileSystemImpl();
};

/* ....................................................................... */
/**
 * Esta classe tem a implementacao dos metodos virtuais de WIOProject
 */
class WIOProjectImpl: public WIOProject {

  private:
	  wio::WIOProject_var wioProject;
	
  public:
	  void destroy(void) throw (wioapi::Exception*);
	  char* getId() const throw (wioapi::Exception*);
	  char* getUser() const throw (wioapi::Exception*);

	  WIOFile* getRootFile() const throw (wioapi::Exception*);
	  WIOFile* getFile(const char* path) const throw (wioapi::Exception*);

	  bool fileExists(const char* path) const throw (wioapi::Exception*);

     long getNumOpenedFiles(void) const throw (wioapi::Exception*);
     long getMaxOpenedFiles(void) const throw (wioapi::Exception*);

	  void renameFile(const char* path, const char* newName) 
        throw (wioapi::Exception*);

	  void deleteFile(const char* path) throw (wioapi::Exception*);

	  void copyFile(const char* fromPath, const char* toPath) 
          throw (wioapi::Exception*);

	  void moveFile(const char* fromPath, const char* toPath) 
          throw (wioapi::Exception*);

	  WIOFile* createDirectory(const char* path) throw (wioapi::Exception*);
	  WIOFile* createFile(const char* path, const char* type, 
          const char* userId) throw (wioapi::Exception*);

	  WIOProjectImpl(wio::WIOProject* wioProject) throw (wioapi::Exception*);
	  ~WIOProjectImpl();
};

/* ....................................................................... */
/**
 * Esta classe tem a implementacao dos metodos virtuais de WIOFile
 */
class WIOFileImpl: WIOFile {
  private:
	 wio::WIOFile_var wioFile;
	 friend class WIOProjectImpl;

  public:
	 void destroy(void) throw (wioapi::Exception*);
	 char* getPath(void) const throw (wioapi::Exception*);
	 WIOFile* getParent(void) const throw (wioapi::Exception*);
	 WIOProject* getProject(void) const throw (wioapi::Exception*);

	 bool canRead(void) const throw (wioapi::Exception*);
	 bool canWrite(void) const throw (wioapi::Exception*);

	 WIOFileMode getMode(void) const throw (wioapi::Exception*);
	 bool isDirectory(void) const throw (wioapi::Exception*);
	 char* getFileType(void) const throw (wioapi::Exception*);

	 long getNumFiles(void) const throw (wioapi::Exception*);
	 WIOFile* getFile(long i) const throw (wioapi::Exception*);

    void appendDescription(const char* desc) const throw (wioapi::Exception*);
    void setDescription(const char* desc) const throw (wioapi::Exception*);
    char* getDescription(void) const throw (wioapi::Exception*);

	 void open(WIOFileMode mode) throw (wioapi::Exception*);
	 void close(void) throw (wioapi::Exception*);

	 long read(long size, char* buffer, long chunk = -1) const 
    throw (wioapi::Exception*);

	 long write(const char* content, long size, long chunk = -1) 
    throw (wioapi::Exception*);

	 long long size(void) const throw (wioapi::Exception*);
	 void resize(long long size) throw (wioapi::Exception*);

	 void seek(long long offset, SeekType type) throw (wioapi::Exception*);
	 long long tell(void) const throw (wioapi::Exception*);
	 bool eof(void) const throw (wioapi::Exception*);

	 bool isUnderConstruction(void) const throw (wioapi::Exception*);
	 bool isPublished(void) const throw (wioapi::Exception*);
	 char* whoCreated(void) const throw (wioapi::Exception*);

    WIODateTimeInfo* lastModificationTime(void) const 
    throw (wioapi::Exception*);

    WIODateTimeInfo* creationTime(void) const 
    throw (wioapi::Exception*);

	 WIOFileImpl(wio::WIOFile* wioFile) throw (wioapi::Exception*);
	 ~WIOFileImpl();
};
