
/**
 * @file TransferDialog.h
 * Arquivo com a interface exportada da classe <code>TransferDialog</code>.
 * @author Aldo de Araujo Nogueira
 * @author Tatiana Almeida Souza Coelho
 */



#ifndef _TRANSFER_DIALOG_H_
#define _TRANSFER_DIALOG_H_

extern "C" {
#include <iup.h>
#include <iupgauge.h>
}
#include <wioapi.h>
#include <util.h>

#include "wiofiledlg.h"

/**
 * Classe que representa um dilogo para buscar arquivos da rea de projetos.
 */
class WIOFILEDLG_API TransferDialog {

  /** Callback chamada quando o usurio clicar no boto de ok . */
  static int transfer_cb(Ihandle * self);
  
  /** Callback chamada quando o usurio clicar no boto de fechar a janela. */
  static int close_cb(Ihandle * self);
  
  /** Callback chamada quando o usurio mudar o estado do toggle de caminho
   *  default. */
  static int useDefault_cb(Ihandle * self, int isOn);
  
  /** Callback chamada quando o usurio clicar no boto de 
   *  browse do sistema de arquivo local. */
  static int localBrowse_cb(Ihandle * self);
  
  /** Callback chamada quando o usurio clicar no boto de browse 
   *  do sistema de arquivo remoto (rea de projetos). */
  static int remoteBrowse_cb(Ihandle * self);
  
  /** Callback chamada quando o usurio clicar no boto de 
   *  cancelar transferncia (na janela de progresso). */
  static int cancelTransfer_cb(Ihandle * self);

  /** Callback chamado quando o usurio escolher a operaco a ser realizada. */
  static int operationRadio_cb(Ihandle * self, int isOn);
  
  /** Callback chamado quando a transferncia estiver em curso. */
  static int idle_function();

  /** Boto de browse de arquivo local */
  Ihandle* localBrowseButton;

  /** Boto de browse de arquivo remoto */
  Ihandle* remoteBrowseButton;
  
  /** Boto de fechar dilogo */
  Ihandle* closeButton;
  
  /** Boto que inicia a transferncia do arquivo */
  Ihandle* transferButton;
  
  /** Caixa de texto com o caminho do arquivo remoto */
  Ihandle* remotePath;
  
  /** Caixa de texto com o caminho do arquivo local */
  Ihandle* localPath;
  
  /** Check box (IupToggle) que indica se ser utilizado o 
   *  caminho default para o arquivo local. */
  Ihandle* useDefaultToggle;

  /** Check box (IupToggle) que indica se ser utilizado o 
   *  diretrio para o destino remoto. */
  Ihandle* useDirToggle;

  /** Janela que indica o progresso da transferncia do arquivo. */
  Ihandle* progressPopup;
 
  /** Controle que apresenta o percentual da transferncia. */
  Ihandle* gauge;
  
  /** Boto que cancela a transferncia na janela de progresso. */
  Ihandle* cancelTransferButton;

  /** checkBox que indica a operaco a ser realizada */
  Ihandle* operationRadio;

  /** Indica qual o tipo do dilogo que deve ser aberto */
  enum WioFileDlgType dialogType;

  /** Id do usurio "dono" dos arquivos de transferncia */
  char* ownerId;
  
  /** Caminho do arquivo local. */
  char* localFileName;
  
  /** Caminho do arquivo remoto. */
  char* remoteFileName;
  
  /** O caminho local default para os arquivos buscados. */
  const char* defaultPath;
  
  /** Separator de diretrios do servidor */
  char* separatorChar;
  
  /** Classe que gerencia a transferncia do arquivo. */
  wioapi::IdleTransfer *idleTransfer;
  
  /** Representa um ponto de acesso  rea de projetos. */
  wioapi::WIOFileSystem *filesystem;
  
  /** Projeto conectado */
  wioapi::WIOProject *project;

  /** Usado em idle_function */
  static TransferDialog* transferDialog;
  
  /** Indica se o dilogo permite enviar e receber ou apenas receber arquivos
   * da rea de projetos. */
  bool getOnly;

  /** Flag de criao de projeto dentro do dilogo. */
  bool createdProject;

  /** Flag de criao de file system dentro do dilogo. */
  bool createdFileSystem;

  /** Usado em idle_function */
  static TransferDialog* getDialog();

  /** Ativa/desativa o boto de transferncia de acordo com 
   *  o estado do dilogo. */
  void activateTransferButton() throw ();
  
  /** Cria uma janela de progresso da transferncia. */
  void createProgressDialog(Ihandle * dialog) throw ();
  
  /** Inicializa as variveis.  chamado a partir dos construtores. */
  void init(const char* defaultPath, bool getOnly, const char* ownerId) 
  throw (wioapi::Exception*);

public:

  /** 
   * Construtor da classe
   * @param filesystem o ponto de acesso  rea de projetos
   * @param project o projeto aberto
   * @param defaultPath o caminho local default para os arquivos buscados.
   * @param getOnly indicador se o dilogo permite enviar e receber ou apenas
   *        receber arquivos da rea de projetos.
   */   
  TransferDialog(wioapi::WIOFileSystem *filesystem, wioapi::WIOProject *project,
    const char* ownerId, const char* defaultPath, bool getOnly) 
    throw (wioapi::Exception*);
  
  /** 
   * Construtor da classe 
   * @param server o nome do servidor
   * @param port a porta do servio de WIO
   * @param user o identificador do usurio
   * @param pwd a senha do usurio
   * @param projectId o identificador do projeto
   * @param defaultPath o caminho local default para os arquivos buscados.
   * @param getOnly indicador se o dilogo permite enviar e receber ou apenas
   *        receber arquivos da rea de projetos.
   */  
  TransferDialog(const char *server, const char *port, const char *user,
    const char *pwd, const char *projectId, const char* ownerId,
    const char* defaultPath, bool getOnly) throw (wioapi::Exception*);
  
  /** Destrutor da classe */
  ~TransferDialog();
  
  /** Cria o dilogo principal */
  Ihandle* createDialog() throw ();
};

#endif // _TRANSFER_DIALOG_H_
