

#include "wioapiimpl.h"
#include "wioapi.h"

// using namespace std;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

void* wioapi::WIOLocator::orb = NULL;
                
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

// .........................................................................

bool wioapi::WIOLocator::finishORB(void) {
  try {
     if (!CORBA::is_nil((CORBA::ORB*)orb)) ((CORBA::ORB*)orb)->destroy();
     return true;
  }
  catch(const CORBA::Exception& ex) {
     cerr << ex << endl;
     return false;
  }
}

// .........................................................................
void wioapi::WIOLocator::setORB(void* userdata) {
   wioapi::WIOLocator::orb = userdata;
}

// .........................................................................
void* wioapi::WIOLocator::startORB(int argc, char* argv[]) {
   try {
     if (orb == NULL) orb = (void*)CORBA::ORB_init(argc, argv);
     return orb;
   }
   catch(CORBA::Exception& ex) {
      cerr << ex << endl;
      return NULL;
   }
}

// .........................................................................
void* wioapi::WIOLocator::getORB(void) {
   return wioapi::WIOLocator::orb;
}

// .........................................................................
const char* wioapi::WIOLocator::createIOR(const char* server, 
const char* port) {
  const char* prefix = "corbaloc::";
  // char* module = "/WIOFileSystem";
  char* module = "/WIOMgr/WIOMgrPOA/WIOFileSystem";
  char* ior = new char[strlen(prefix) + strlen(server) +
        strlen(":") + strlen(port) + strlen(module) + 1];

  strcpy(ior, prefix);
  strcat(ior, server);
  strcat(ior, ":");
  strcat(ior, port);
  strcat(ior, module);
  return ior;
}

// .........................................................................
WIOFileSystem* wioapi::WIOLocator::buildFileSystem(const char* ior) {
   return new WIOFileSystemImpl((char*)ior);
}


