#include <string.h> 
#include <iostream>
#include <TransferDialog.h>

#include <iupcontrols.h>

/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */

using namespace wioapi;
using namespace std;

/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/* ----------------------------------------------------------------------- */


/* ....................................................................... */
/**
 Extrai o valor de um determinado parmetro da linha de comando 
 (endereo e porta do servidor, por exemplo).
 @param cmdOption Indica qual  o parmetro do qual se deseja obter o valor
 @param argc Nmero de parmetros na linha de comando
 @param argv Vetor de parmetros da linha de comando
 @param mandatory Indica se o parmetro  obrigatrio
*/
char* getParameter(const char* cmdOption, int argc, char *argv[], bool mandatory)
{
  for(int i=0; i<argc; i++)
  {
    // se um dos parmetros da linha de comando comea por cmdOption, ento o valor
    // do parmetro  retornado
    if(strstr(argv[i], cmdOption) == argv[i])
    {
      return argv[i]+strlen(cmdOption);
    }
  }
  if(mandatory)
  {
    cout << "Uso:\ntestFileDialog --server=<server> --port=<port> " <<
      "--user=<user> --passwd=<passwd> --projectId=<projectId> " << 
      "--defaultPath=<defaultPath> --lang=<language>\n" << endl;
    exit(1);
  }
  else
  {
    return NULL;
  }
}



/* ....................................................................... */

int main(int argc, char *argv[]) {
  /* Initializes IUP */
  IupOpen(NULL, NULL);
  IupControlsOpen();

  const char* server = getParameter("--server=", argc, argv, true);
  const char* port = getParameter("--port=", argc, argv, true);
  const char* user = getParameter("--user=", argc, argv, true);
  const char* passwd = getParameter("--passwd=", argc, argv, true);
  const char* projectId = getParameter("--projectId=", argc, argv, true);
  const char* defaultPath = getParameter("--defaultPath=", argc, argv, true);
  const char* language = getParameter("--lang=", argc, argv, false);
  if (language != NULL && strcmp(language, "en_US") == 0) {
    IupSetLanguage(IUP_ENGLISH);
  } else {
    IupSetLanguage(IUP_PORTUGUESE);
  }

  void* orb = WIOLocator::startORB(argc, argv);
  if (orb == NULL) {
     cout << "No ORB found! Bye!" << endl;
     exit(1);
  }

  TransferDialog* vistaPaeDialog = new TransferDialog(
    (const char*)server, (const char*)port, (const char*)user, 
    (const char*)passwd, (const char*)projectId, (const char*)user, 
    (const char*)defaultPath, (bool)false);

  Ihandle *dialog = vistaPaeDialog->createDialog();

  IupShow(dialog);

  IupMainLoop();

  IupDestroy(dialog);

  IupClose();                   

  delete vistaPaeDialog;

  return 0;
}
