package csdk.v1_0.api.command;

import java.util.Map;

/**
 * Define as informaes do algoritmo a ser executado.
 */
public interface IAlgorithmTemplate {

  /**
   * Obtm o nome do algoritmo.
   * 
   * @return o nome do algoritmo
   */
  public String getAlgorithmName();

  /**
   * Obtm o identificador da verso do algoritmo.
   * 
   * @return o identificador da verso do algoritmo
   */
  public String getAlgorithmVersionId();

  /**
   * Obtm todos os valores dos parmetros do algoritmo que foram preenchidos.
   * 
   * @return um mapa com todos os parmetros preenchidos e seus respectivos
   *         valores
   */
  public Map<String, String> getParametersValues();

}
