package csdk.v2.helper.application;

import java.net.URL;

import javax.swing.ImageIcon;

/**
 * Imagens comuns para uso no CSDK.
 */
public class ApplicationImages {

  /**
   * <img style="text-align:right;" src="../../../About16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de mostrar painel "sobre" da
   * aplicao.
   */
  public static final ImageIcon ICON_ABOUT_16 = createImageIcon("About16");

  /**
   * <img style="text-align:right;" src="../../../Add16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de adicionar itens.
   */
  public static final ImageIcon ICON_ADD_16 = createImageIcon("Add16");

  /**
   * <img style="text-align:right;" src="../../../Animated32.gif" alt="">
   * cone-padro 32x32 animado: rodas dentadas.
   */
  public static final ImageIcon ICON_ANIMATEDENGINES_32 = createImageIcon(
    "Animated32");

  /**
   * <img style="text-align:right;" src="../../../Apply16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de aplicar.
   */
  public static final ImageIcon ICON_APPLY_16 = createImageIcon("Apply16");

  /**
   * <img style="text-align:right;" src="../../../BrowseFile16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de navegao e seleo de
   * arquivos.
   */
  public static final ImageIcon ICON_BROWSEFILE_16 = createImageIcon(
    "BrowseFile16");

  /**
   * <img style="text-align:right;" src="../../../BrowseLocalFile16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de navegao e seleo de
   * arquivos locais.
   */
  public static final ImageIcon ICON_BROWSELOCALFILE_16 = createImageIcon(
    "BrowseLocalFile16");

  /**
   * <img style="text-align:right;" src="../../../Cancel16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de cancelamento.
   */
  public static final ImageIcon ICON_CANCEL_16 = createImageIcon("Cancel16");

  /**
   * <img style="text-align:right;" src="../../../ChangeColor16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de seleo de cores.
   */
  public static final ImageIcon ICON_CHANGECOLOR_16 = createImageIcon(
    "ChangeColor16");

  /**
   * <img style="text-align:right;" src="../../../Close16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de fechar.
   */
  public static final ImageIcon ICON_CLOSE_16 = createImageIcon("Close16");

  /**
   * <img style="text-align:right;" src="../../../Copy16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de copiar.
   */
  public static final ImageIcon ICON_COPY_16 = createImageIcon("Copy16");

  /**
   * <img style="text-align:right;" src="../../../Cut16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de cortar.
   */
  public static final ImageIcon ICON_CUT_16 = createImageIcon("Cut16");

  /**
   * <img style="text-align:right;" src="../../../Delete16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de remoo.
   */
  public static final ImageIcon ICON_DELETE_16 = createImageIcon("Delete16");

  /**
   * <img style="text-align:right;" src="../../../Down16.gif" alt="">
   * cone-padro 16x16 de uso geral: seta para baixo.
   */
  public static final ImageIcon ICON_DOWN_16 = createImageIcon("Down16");

  /**
   * <img style="text-align:right;" src="../../../Edit16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de edio.
   */
  public static final ImageIcon ICON_EDIT_16 = createImageIcon("Edit16");

  /**
   * <img style="text-align:right;" src="../../../Error16.gif" alt="">
   * cone-padro 16x16 de uso geral: para indicao de erro.
   */
  public static final ImageIcon ICON_ERROR_16 = createImageIcon("Error16");

  /**
   * <img style="text-align:right;" src="../../../Exit16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de sair da aplicao.
   */
  public static final ImageIcon ICON_EXIT_16 = createImageIcon("Exit16");

  /**
   * <img style="text-align:right;" src="../../../Export16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de exportao.
   */
  public static final ImageIcon ICON_EXPORT_16 = createImageIcon("Export16");

  /**
   * <img style="text-align:right;" src="../../../File16.gif" alt="">
   * cone-padro 16x16 de uso geral: para representar arquivos.
   */
  public static final ImageIcon ICON_FILE_16 = createImageIcon("File16");

  /**
   * <img style="text-align:right;" src="../../../FileLocal16.gif" alt="">
   * cone-padro 16x16 de uso geral: para representar arquivos locais.
   */
  public static final ImageIcon ICON_FILE_LOCAL_16 = createImageIcon(
    "FileLocal16");

  /**
   * <img style="text-align:right;" src="../../../FileProject16.gif" alt="">
   * cone-padro 16x16 de uso geral: para representar arquivos de projeto.
   */
  public static final ImageIcon ICON_FILE_PROJECT_16 = createImageIcon(
    "FileProject16");

  /**
   * <img style="text-align:right;" src="../../../Find16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de busca.
   */
  public static final ImageIcon ICON_FIND_16 = createImageIcon("Find16");

  /**
   * <img style="text-align:right;" src="../../../Fit16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de ajuste.
   */
  public static final ImageIcon ICON_FIT_16 = createImageIcon("Fit16");

  /**
   * <img style="text-align:right;" src="../../../Help16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de ajuda.
   */
  public static final ImageIcon ICON_HELP_16 = createImageIcon("Help16");

  /**
   * <img style="text-align:right;" src="../../../Fit16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de importao.
   */
  public static final ImageIcon ICON_IMPORT_16 = createImageIcon("Import16");

  /**
   * <img style="text-align:right;" src="../../../Information16.gif" alt="">
   * cone-padro 16x16 de uso geral: para indicao de informaes.
   */
  public static final ImageIcon ICON_INFORMATION_16 = createImageIcon(
    "Information16");

  /**
   * <img style="text-align:right;" src="../../../Left16.gif" alt="">
   * cone-padro 16x16 de uso geral: seta  esquerda.
   */
  public static final ImageIcon ICON_LEFT_16 = createImageIcon("Left16");

  /**
   * <img style="text-align:right;" src="../../../New16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de criar novo item.
   */
  public static final ImageIcon ICON_NEW_16 = createImageIcon("New16");

  /**
   * <img style="text-align:right;" src="../../../None.gif" alt=""> cone-padro
   * 16x16 de uso geral: para indicao de problemas.
   */
  public static final ImageIcon ICON_NONE = createImageIcon("None");

  /**
   * <img style="text-align:right;" src="../../../Ok16.gif" alt=""> cone-padro
   * 16x16 de uso geral: para indicao de sucesso.
   */
  public static final ImageIcon ICON_OK_16 = createImageIcon("Ok16");

  /**
   * <img style="text-align:right;" src="../../../Open16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de abrir arquivos.
   */
  public static final ImageIcon ICON_OPEN_16 = createImageIcon("Open16");

  /**
   * <img style="text-align:right;" src="../../../OpenLocal16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de abrir arquivos locais.
   */
  public static final ImageIcon ICON_OPEN_LOCAL_16 = createImageIcon(
    "OpenLocal16");

  /**
   * <img style="text-align:right;" src="../../../Paste16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de colar.
   */
  public static final ImageIcon ICON_PASTE_16 = createImageIcon("Paste16");

  /**
   * <img style="text-align:right;" src="../../../Pause16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de pausar.
   */
  public static final ImageIcon ICON_PAUSE_16 = createImageIcon("Pause16");

  /**
   * <img style="text-align:right;" src="../../../Play16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de tocar.
   */
  public static final ImageIcon ICON_PLAY_16 = createImageIcon("Play16");

  /**
   * <img style="text-align:right;" src="../../../Print16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de impresso.
   */
  public static final ImageIcon ICON_PRINT_16 = createImageIcon("Print16");

  /**
   * <img style="text-align:right;" src="../../../Question16.gif" alt="">
   * cone-padro 16x16 de uso geral: para indicao de pergunta.
   */
  public static final ImageIcon ICON_QUESTION_16 = createImageIcon(
    "Question16");

  /**
   * <img style="text-align:right;" src="../../../Refresh16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de recarga.
   */
  public static final ImageIcon ICON_REFRESH_16 = createImageIcon("Refresh16");

  /**
   * <img style="text-align:right;" src="../../../Rename16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de renomear.
   */
  public static final ImageIcon ICON_RENAME_16 = createImageIcon("Rename16");

  /**
   * <img style="text-align:right;" src="../../../Reset16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de reinicar.
   */
  public static final ImageIcon ICON_RESET_16 = createImageIcon("Reset16");

  /**
   * <img style="text-align:right;" src="../../../Right16.gif" alt="">
   * cone-padro 16x16 de uso geral: seta  direita.
   */
  public static final ImageIcon ICON_RIGHT_16 = createImageIcon("Right16");

  /**
   * <img style="text-align:right;" src="../../../Save16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de salvar arquivos.
   */
  public static final ImageIcon ICON_SAVE_16 = createImageIcon("Save16");

  /**
   * <img style="text-align:right;" src="../../../SaveAs16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de "salvar como" arquivos.
   */
  public static final ImageIcon ICON_SAVEAS_16 = createImageIcon("SaveAs16");

  /**
   * <img style="text-align:right;" src="../../../SaveAsLocal16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de "salvar como" arquivos
   * locais.
   */
  public static final ImageIcon ICON_SAVEAS_LOCAL_16 = createImageIcon(
    "SaveAsLocal16");

  /**
   * <img style="text-align:right;" src="../../../Up16.gif" alt=""> cone-padro
   * 16x16 de uso geral: seta para cima.
   */
  public static final ImageIcon ICON_UP_16 = createImageIcon("Up16");

  /**
   * <img style="text-align:right;" src="../../../Warning16.gif" alt="">
   * cone-padro 16x16 de uso geral: para indicao de aviso.
   */
  public static final ImageIcon ICON_WARNING_16 = createImageIcon("Warning16");

  /**
   * <img style="text-align:right;" src="../../../Zoom16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de zoom.
   */
  public static final ImageIcon ICON_ZOOM_16 = createImageIcon("Zoom16");

  /**
   * <img style="text-align:right;" src="../../../ZoomIn16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de zoom (aproximando).
   */
  public static final ImageIcon ICON_ZOOMIN_16 = createImageIcon("ZoomIn16");

  /**
   * <img style="text-align:right;" src="../../../ZoomOut16.gif" alt="">
   * cone-padro 16x16 de uso geral: para aes de zoom (afastando).
   */
  public static final ImageIcon ICON_ZOOMOUT_16 = createImageIcon("ZoomOut16");

  /**
   * Diretrio das imagens padro do CSDK.
   */
  private static final String IMAGE_DIRECTORY = "resources/images/";

  /**
   * Construtor.
   */
  protected ApplicationImages() {
    //Construtor privado para no haver instanciao.
  }

  /**
   * Montagem do cone do diretrio-padro.
   *
   * @param imageIconName nome do arquivo de imagem.
   * @return uma imagem (cone)
   */
  private static ImageIcon createImageIcon(String imageIconName) {
    return createImageIcon(imageIconName, ApplicationImages.class);
  }

  /**
   * Montagem do cone a partir de uma classe no diretrio-padro.
   *
   * @param imageIconName nome do arquivo de imagem.
   * @param resourceClass classe a partir da qual a imagem ser carregada.
   *
   * @return uma imagem (cone)
   */
  public static ImageIcon createImageIcon(String imageIconName,
    Class<?> resourceClass) {
    return createImageIcon(imageIconName, resourceClass, IMAGE_DIRECTORY);
  }

  /**
   * Montagem do cone a partir de uma classe no diretrio especificado.
   *
   * @param imageIconName nome do arquivo de imagem.
   * @param resourceClass classe a partir da qual a imagem ser carregada.
   * @param imageDirectory diretrio de imagens.
   *
   * @return uma imagem (cone)
   */
  public static ImageIcon createImageIcon(String imageIconName,
    Class<?> resourceClass, String imageDirectory) {
    String resPath = imageDirectory + imageIconName + "." + "gif";
    URL res = resourceClass.getResource(resPath);
    if (res == null) {
      return ICON_NONE;
    }
    return new ImageIcon(res);
  }
}
