package csdk.v2.helper.command.parameters;

import java.util.List;

/**
 * Conversor genrico para parmetros com valor lista de um tipo {@code <T>}.
 * 
 * @param <T> o tipo da lista.
 */
public class ListValueConverter<T> implements ParameterValueConverter<List<T>> {

  /**
   * Caractere que define o incio de uma lista.
   */
  private static final char START_LINE_CHAR = '{';

  /**
   * Caractere que separa os elementos da lista.
   */
  private static final char ELEMENT_SEPARATOR_CHAR = ',';

  /**
   * Caractere que define o fim de uma lista.
   */
  private static final char END_LINE_CHAR = '}';

  /**
   * Conversor de uma unidade {@code <T>} da lista.
   */
  private final ParameterValueConverter<T> singleValueConverter;

  /**
   * Construtor.
   * 
   * @param singleValueConverter o conversor de uma unidade {@code <T>} da
   *        lista.
   */
  public ListValueConverter(ParameterValueConverter<T> singleValueConverter) {
    this.singleValueConverter = singleValueConverter;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValueAsString(List<T> values)
    throws ParameterValueConvertionException {
    if (values == null || values.size() == 0) {
      return null;
    }
    StringBuffer buffer = new StringBuffer();
    buffer.append(START_LINE_CHAR);
    String separator = "";
    for (T value : values) {
      buffer.append(separator);
      buffer.append(singleValueConverter.getValueAsString(value));
      separator = Character.toString(ELEMENT_SEPARATOR_CHAR);
    }
    buffer.append(END_LINE_CHAR);
    return buffer.toString();
  }

}
