package csdk.v2.helper.command.parameters;

/**
 * Define converses dentre os tipos {@code <T>} dos parmetros e String.
 * 
 * @param <T> Tipo do parmetro.
 */
public interface ParameterValueConverter<T> {

  /**
   * Retorna o valor aps a sua converso para string.
   * 
   * @param obj valor a ser convertido.
   * @return a string gerada.
   * 
   * @throws ParameterValueConvertionException caso no seja possvel fazer a
   *         converso.
   */
  public String getValueAsString(T obj)
    throws ParameterValueConvertionException;
}
