package csdk.v2.helper.command.parameters;

/**
 * Valor de parmetros do tipo URL.
 */
public class URLParameterValue extends AbstractParameterValue<URL> {

  /**
   * Construtor.
   * 
   * @param path o caminho para o arquivo.
   * @param type o tipo do arquivo.
   * @param protocol o protocolo da URL.
   * @param host o host da URL.
   */
  public URLParameterValue(String path, String type, String protocol,
    String host) {
    super(new URL(path, type, protocol, host));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ParameterValueConverter<URL> getValueConverter() {
    return new URLValueConverter();
  }

}
