package csdk.v1_0.runner.application;

import javax.swing.ImageIcon;

import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.runner.ApplicationRegistry;
import csdk.v1_0.runner.Runner;
import csdk.v1_0.runner.core.AbstractContext;

/**
 * Contexto da aplicao na sandbox do CSDK.
 * 
 * Essa classe *no* deve ser usada por desenvolvedores CSDK em suas aplicaes.
 * Ela  de uso exclusivo do ambiente simulado do {@link Runner}.
 */
public class ApplicationContext extends AbstractContext implements
  IApplicationContext {

  /**
   * Identificador nico da instncia da aplicao
   */
  private final String instanceId;

  /**
   * Registro da aplicao.
   */
  private final ApplicationRegistry registry;

  /**
   * Construtor.
   * 
   * @param instanceId instncia da aplicao associada a esse contexto;
   * @param reg registro da aplicao.
   */
  public ApplicationContext(String instanceId, ApplicationRegistry reg) {
    this.instanceId = instanceId;
    this.registry = reg;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getApplicationIcon() {
    return registry.getApplicationIcon();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationId() {
    return registry.getApplicationId();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationName() {
    return registry.getApplicationName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getVersion() {
    return registry.getVersion();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon(String[] path) {
    return registry.getImageIcon(path);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getInstanceId() {
    return instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getProperty(String propName) {
    return registry.getProperty(propName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getSmallApplicationIcon() {
    return registry.getSmallApplicationIcon();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getString(String key, Object... args) {
    return registry.getString(key, args);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean hasString(String key) {
    return registry.hasString(key);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isBundleRequired() {
    return registry.isBundleRequired();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isPropertyNull(String propName) {
    return registry.isPropertyNull(propName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String[] getApplicationFileTypes() {
    return registry.getFileTypes();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getAuthor() {
    return registry.getAuthor();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getAuthorEmail() {
    return registry.getAuthorEmail();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getApplicationDescription() {
    return registry.getApplicationDescription();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isSingleton() {
    return registry.isSingleton();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean requiresProject() {
    return registry.requiresProject();
  }

}
