/*
 * Decompiled with CFR 0.152.
 */
package fxcalculator;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.fx.helper.AbstractJFXApplication;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javax.swing.JFrame;

public class FXCalculator
extends AbstractJFXApplication {
    private static final String[][] template = new String[][]{{"7", "8", "9", "/"}, {"4", "5", "6", "*"}, {"1", "2", "3", "-"}, {"0", "c", "=", "+"}};
    private final Map<String, Button> accelerators = new HashMap<String, Button>();
    private DoubleProperty stackValue = new SimpleDoubleProperty();
    private DoubleProperty value = new SimpleDoubleProperty();
    private Op curOp = Op.NOOP;
    private Op stackOp = Op.NOOP;

    public FXCalculator(ICSDKEnvironment csdkInterface) {
        super(csdkInterface);
    }

    protected void applicationEnded() throws ApplicationException {
    }

    protected void applicationStarted(JFrame mainFrame) throws ApplicationException {
        mainFrame.setSize(new Dimension(250, 300));
        mainFrame.setLocationRelativeTo(null);
    }

    protected Parent getParentNode() throws Exception {
        TextField screen = this.createScreen();
        TilePane buttons = this.createButtons();
        return this.createLayout(screen, buttons);
    }

    private VBox createLayout(TextField screen, TilePane buttons) {
        VBox layout = new VBox(20.0);
        layout.setAlignment(Pos.CENTER);
        layout.setStyle("-fx-background-color: chocolate; -fx-padding: 20; -fx-font-size: 20;");
        layout.getChildren().setAll((Object[])new Node[]{screen, buttons});
        this.handleAccelerators(layout);
        screen.prefWidthProperty().bind((ObservableValue)buttons.widthProperty());
        return layout;
    }

    private void handleAccelerators(VBox layout) {
        layout.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                Button activated = (Button)FXCalculator.this.accelerators.get(keyEvent.getText());
                if (activated != null) {
                    activated.fire();
                }
            }
        });
    }

    private TextField createScreen() {
        TextField screen = new TextField();
        screen.setStyle("-fx-background-color: aquamarine;");
        screen.setAlignment(Pos.CENTER_RIGHT);
        screen.setEditable(false);
        screen.textProperty().bind((ObservableValue)Bindings.format((String)"%.0f", (Object[])new Object[]{this.value}));
        return screen;
    }

    private TilePane createButtons() {
        TilePane buttons = new TilePane();
        buttons.setVgap(7.0);
        buttons.setHgap(7.0);
        buttons.setPrefColumns(template[0].length);
        buttons.setPrefRows(template.length);
        String[][] stringArray = template;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] r;
            for (String s : r = stringArray[i]) {
                buttons.getChildren().add((Object)this.createButton(s));
            }
        }
        return buttons;
    }

    private Button createButton(String s) {
        Button button = this.makeStandardButton(s);
        if (s.matches("[0-9]")) {
            this.makeNumericButton(s, button);
        } else {
            ObjectProperty<Op> triggerOp = this.determineOperand(s);
            if (triggerOp.get() != Op.NOOP) {
                this.makeOperandButton(button, triggerOp);
            } else if ("c".equals(s)) {
                this.makeClearButton(button);
            } else if ("=".equals(s)) {
                this.makeEqualsButton(button);
            }
        }
        return button;
    }

    private ObjectProperty<Op> determineOperand(String s) {
        SimpleObjectProperty triggerOp = new SimpleObjectProperty((Object)Op.NOOP);
        switch (s) {
            case "+": {
                triggerOp.set((Object)Op.ADD);
                break;
            }
            case "-": {
                triggerOp.set((Object)Op.SUBTRACT);
                break;
            }
            case "*": {
                triggerOp.set((Object)Op.MULTIPLY);
                break;
            }
            case "/": {
                triggerOp.set((Object)Op.DIVIDE);
            }
        }
        return triggerOp;
    }

    private void makeOperandButton(Button button, final ObjectProperty<Op> triggerOp) {
        button.setStyle("-fx-base: lightgray;");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXCalculator.this.curOp = (Op)((Object)triggerOp.get());
            }
        });
    }

    private Button makeStandardButton(String s) {
        Button button = new Button(s);
        button.setStyle("-fx-base: beige;");
        this.accelerators.put(s, button);
        button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return button;
    }

    private void makeNumericButton(final String s, Button button) {
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                if (FXCalculator.this.curOp == Op.NOOP) {
                    FXCalculator.this.value.set(FXCalculator.this.value.get() * 10.0 + (double)Integer.parseInt(s));
                } else {
                    FXCalculator.this.stackValue.set(FXCalculator.this.value.get());
                    FXCalculator.this.value.set((double)Integer.parseInt(s));
                    FXCalculator.this.stackOp = FXCalculator.this.curOp;
                    FXCalculator.this.curOp = Op.NOOP;
                }
            }
        });
    }

    private void makeClearButton(Button button) {
        button.setStyle("-fx-base: mistyrose;");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FXCalculator.this.value.set(0.0);
            }
        });
    }

    private void makeEqualsButton(Button button) {
        button.setStyle("-fx-base: ghostwhite;");
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                switch (FXCalculator.this.stackOp) {
                    case ADD: {
                        FXCalculator.this.value.set(FXCalculator.this.stackValue.get() + FXCalculator.this.value.get());
                        break;
                    }
                    case SUBTRACT: {
                        FXCalculator.this.value.set(FXCalculator.this.stackValue.get() - FXCalculator.this.value.get());
                        break;
                    }
                    case MULTIPLY: {
                        FXCalculator.this.value.set(FXCalculator.this.stackValue.get() * FXCalculator.this.value.get());
                        break;
                    }
                    case DIVIDE: {
                        FXCalculator.this.value.set(FXCalculator.this.stackValue.get() / FXCalculator.this.value.get());
                    }
                }
            }
        });
    }

    private static enum Op {
        NOOP,
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;

    }
}

